/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.xml.maven.helpers;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.maven.model.maven2.Build;
import org.sonar.maven.model.maven2.BuildBase;
import org.sonar.maven.model.maven2.Dependency;
import org.sonar.maven.model.maven2.DependencyManagement;
import org.sonar.maven.model.maven2.MavenProject;
import org.sonar.maven.model.maven2.Plugin;
import org.sonar.maven.model.maven2.Profile;

public class MavenDependencyCollector {
    private final List<Dependency> dependencies;

    public MavenDependencyCollector(MavenProject mavenProject) {
        this.dependencies = MavenDependencyCollector.collectAllDependencies(mavenProject);
    }

    public List<Dependency> allDependencies() {
        return this.dependencies;
    }

    private static List<Dependency> collectAllDependencies(MavenProject mavenProject) {
        LinkedList<Dependency> results = new LinkedList<Dependency>();
        results.addAll(MavenDependencyCollector.fromDependencyManagement(mavenProject.getDependencyManagement()));
        results.addAll(mavenProject.getDependencies() != null ? mavenProject.getDependencies().getDependencies() : Collections.emptyList());
        results.addAll(MavenDependencyCollector.fromBuild(mavenProject.getBuild()));
        results.addAll(MavenDependencyCollector.fromProfiles(mavenProject.getProfiles()));
        return results;
    }

    private static List<Dependency> fromBuild(@Nullable Build build) {
        if (build != null) {
            LinkedList<Dependency> results = new LinkedList<Dependency>();
            if (build.getPluginManagement() != null && build.getPluginManagement().getPlugins() != null) {
                results.addAll(MavenDependencyCollector.fromPlugins(build.getPluginManagement().getPlugins().getPlugins()));
            }
            if (build.getPlugins() != null) {
                results.addAll(MavenDependencyCollector.fromPlugins(build.getPlugins().getPlugins()));
            }
            return results;
        }
        return Collections.emptyList();
    }

    private static List<Dependency> fromPlugins(List<Plugin> plugins) {
        for (Plugin plugin : plugins) {
            if (plugin.getDependencies() == null) continue;
            return plugin.getDependencies().getDependencies();
        }
        return Collections.emptyList();
    }

    private static List<Dependency> fromProfiles(@Nullable MavenProject.Profiles profiles) {
        if (profiles != null) {
            LinkedList<Dependency> results = new LinkedList<Dependency>();
            for (Profile profile : profiles.getProfiles()) {
                results.addAll(MavenDependencyCollector.fromDependencyManagement(profile.getDependencyManagement()));
                results.addAll(profile.getDependencies() != null ? profile.getDependencies().getDependencies() : Collections.emptyList());
                results.addAll(MavenDependencyCollector.fromBuild(profile.getBuild()));
            }
            return results;
        }
        return Collections.emptyList();
    }

    private static List<Dependency> fromBuild(@Nullable BuildBase build) {
        if (build != null) {
            LinkedList<Dependency> results = new LinkedList<Dependency>();
            if (build.getPluginManagement() != null && build.getPluginManagement().getPlugins() != null) {
                results.addAll(MavenDependencyCollector.fromPlugins(build.getPluginManagement().getPlugins().getPlugins()));
            }
            if (build.getPlugins() != null) {
                results.addAll(MavenDependencyCollector.fromPlugins(build.getPlugins().getPlugins()));
            }
            return results;
        }
        return Collections.emptyList();
    }

    private static List<Dependency> fromDependencyManagement(@Nullable DependencyManagement depMgmt) {
        DependencyManagement.Dependencies dependencies;
        if (depMgmt != null && (dependencies = depMgmt.getDependencies()) != null) {
            return dependencies.getDependencies();
        }
        return Collections.emptyList();
    }
}

