/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.xml.maven.helpers;

import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.java.checks.xml.maven.helpers.LocatedAttributeMatcher;
import org.sonar.maven.model.LocatedAttribute;

public class PatternMatcher
implements LocatedAttributeMatcher {
    private final Pattern pattern;

    public PatternMatcher(String regex) {
        this.pattern = PatternMatcher.compileRegex(regex);
    }

    @Override
    public boolean test(@Nullable LocatedAttribute attribute) {
        return attribute != null && this.pattern.matcher(attribute.getValue()).matches();
    }

    private static Pattern compileRegex(String regex) {
        try {
            return Pattern.compile(regex, 32);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unable to compile the regular expression: " + regex, e);
        }
    }
}

