/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.xml.struts;

import com.google.common.collect.Lists;
import java.util.HashMap;
import javax.annotation.CheckForNull;
import javax.xml.xpath.XPathExpression;
import org.sonar.check.Rule;
import org.sonar.java.xml.XPathXmlCheck;
import org.sonar.java.xml.XmlCheckContext;
import org.sonar.java.xml.XmlCheckUtils;
import org.sonar.plugins.java.api.JavaCheck;
import org.w3c.dom.Node;

@Rule(key="S3374")
public class FormNameDuplicationCheck
extends XPathXmlCheck {
    private XPathExpression formsetsExpression;
    private XPathExpression formsExpression;

    public void precompileXPathExpressions(XmlCheckContext context) {
        this.formsetsExpression = context.compile("form-validation/formset");
        this.formsExpression = context.compile("form");
    }

    public void scanFileWithXPathExpressions(XmlCheckContext context) {
        for (Node formset : context.evaluateOnDocument(this.formsetsExpression)) {
            HashMap<String, Node> formsByName = new HashMap<String, Node>();
            for (Node form : context.evaluate(this.formsExpression, formset)) {
                String name = FormNameDuplicationCheck.getNameAttribute(form);
                Node original = (Node)formsByName.get(name);
                if (original == null) {
                    formsByName.put(name, form);
                    continue;
                }
                this.reportIssue(context, form, original);
            }
        }
    }

    private void reportIssue(XmlCheckContext context, Node form, Node original) {
        String msg = "Rename this form; line " + XmlCheckUtils.nodeLine((Node)original) + " holds another form declaration with the same name.";
        XmlCheckContext.XmlDocumentLocation secondary = new XmlCheckContext.XmlDocumentLocation("original", original);
        context.reportIssue((JavaCheck)this, form, msg, (Iterable)Lists.newArrayList((Object[])new XmlCheckContext.XmlDocumentLocation[]{secondary}));
    }

    @CheckForNull
    private static String getNameAttribute(Node form) {
        Node name = XmlCheckUtils.nodeAttribute((Node)form, (String)"name");
        if (name != null) {
            return name.getNodeValue();
        }
        return null;
    }
}

