/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.filters;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.java.checks.AtLeastOneConstructorCheck;
import org.sonar.java.checks.ConstantsShouldBeStaticFinalCheck;
import org.sonar.java.checks.EqualsNotOverriddenInSubclassCheck;
import org.sonar.java.checks.EqualsNotOverridenWithCompareToCheck;
import org.sonar.java.checks.PrivateFieldUsedLocallyCheck;
import org.sonar.java.checks.UtilityClassWithPublicConstructorCheck;
import org.sonar.java.checks.naming.BadFieldNameCheck;
import org.sonar.java.checks.unused.UnusedPrivateFieldCheck;
import org.sonar.java.filters.BaseTreeVisitorIssueFilter;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;

public class LombokFilter
extends BaseTreeVisitorIssueFilter {
    private static final Set<Class<? extends JavaCheck>> FILTERED_RULES = ImmutableSet.of(UnusedPrivateFieldCheck.class, PrivateFieldUsedLocallyCheck.class, EqualsNotOverriddenInSubclassCheck.class, EqualsNotOverridenWithCompareToCheck.class, UtilityClassWithPublicConstructorCheck.class, AtLeastOneConstructorCheck.class, (Object[])new Class[]{BadFieldNameCheck.class, ConstantsShouldBeStaticFinalCheck.class});
    private static final List<String> GENERATE_UNUSED_FIELD_RELATED_METHODS = ImmutableList.builder().add((Object)"lombok.Getter").add((Object)"lombok.Setter").add((Object)"lombok.Builder").add((Object)"lombok.ToString").add((Object)"lombok.AllArgsConstructor").add((Object)"lombok.NoArgsConstructor").add((Object)"lombok.RequiredArgsConstructor").build();
    private static final List<String> GENERATE_CONSTRUCTOR = ImmutableList.builder().add((Object)"lombok.AllArgsConstructor").add((Object)"lombok.NoArgsConstructor").add((Object)"lombok.RequiredArgsConstructor").build();
    private static final List<String> GENERATE_EQUALS = ImmutableList.builder().add((Object)"lombok.EqualsAndHashCode").add((Object)"lombok.Data").add((Object)"lombok.Value").build();
    private static final List<String> UTILITY_CLASS = ImmutableList.builder().add((Object)"lombok.experimental.UtilityClass").build();

    @Override
    public Set<Class<? extends JavaCheck>> filteredRules() {
        return FILTERED_RULES;
    }

    public void visitClass(ClassTree tree) {
        boolean generatesEquals = LombokFilter.usesAnnotation(tree, GENERATE_EQUALS);
        if (generatesEquals || LombokFilter.usesAnnotation(tree, GENERATE_UNUSED_FIELD_RELATED_METHODS)) {
            this.excludeLines((Tree)tree, UnusedPrivateFieldCheck.class);
            this.excludeLines((Tree)tree, PrivateFieldUsedLocallyCheck.class);
        } else {
            this.acceptLines((Tree)tree, UnusedPrivateFieldCheck.class);
            this.acceptLines((Tree)tree, PrivateFieldUsedLocallyCheck.class);
        }
        if (LombokFilter.usesAnnotation(tree, GENERATE_CONSTRUCTOR)) {
            this.excludeLines((Tree)tree, AtLeastOneConstructorCheck.class);
        } else {
            this.acceptLines((Tree)tree, AtLeastOneConstructorCheck.class);
        }
        if (generatesEquals) {
            this.excludeLines((Tree)tree, EqualsNotOverriddenInSubclassCheck.class);
            this.excludeLines((Tree)tree, EqualsNotOverridenWithCompareToCheck.class);
        } else {
            this.acceptLines((Tree)tree, EqualsNotOverriddenInSubclassCheck.class);
            this.acceptLines((Tree)tree, EqualsNotOverridenWithCompareToCheck.class);
        }
        if (LombokFilter.generatesPrivateConstructor(tree)) {
            this.excludeLines((Tree)tree, UtilityClassWithPublicConstructorCheck.class);
        } else {
            this.acceptLines((Tree)tree, UtilityClassWithPublicConstructorCheck.class);
        }
        if (LombokFilter.usesAnnotation(tree, UTILITY_CLASS)) {
            this.excludeLines((Tree)tree, BadFieldNameCheck.class);
            this.excludeLines((Tree)tree, ConstantsShouldBeStaticFinalCheck.class);
        } else {
            this.acceptLines((Tree)tree, BadFieldNameCheck.class);
            this.acceptLines((Tree)tree, ConstantsShouldBeStaticFinalCheck.class);
        }
        super.visitClass(tree);
    }

    private static boolean usesAnnotation(ClassTree classTree, List<String> annotations) {
        SymbolMetadata metadata = classTree.symbol().metadata();
        for (String annotation : annotations) {
            if (!metadata.isAnnotatedWith(annotation)) continue;
            return true;
        }
        return false;
    }

    private static boolean generatesPrivateConstructor(ClassTree classTree) {
        if (LombokFilter.usesAnnotation(classTree, UTILITY_CLASS)) {
            return true;
        }
        SymbolMetadata metadata = classTree.symbol().metadata();
        return GENERATE_CONSTRUCTOR.stream().map(arg_0 -> ((SymbolMetadata)metadata).valuesForAnnotation(arg_0)).filter(Objects::nonNull).anyMatch(LombokFilter::generatesPrivateAccess);
    }

    private static boolean generatesPrivateAccess(List<SymbolMetadata.AnnotationValue> values) {
        return values.stream().anyMatch(av -> "access".equals(av.name()) && "PRIVATE".equals(LombokFilter.getAccessLevelValue(av.value())));
    }

    @Nullable
    private static String getAccessLevelValue(Object value) {
        if (value instanceof Tree) {
            Tree tree = (Tree)value;
            if (tree.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                return ((MemberSelectExpressionTree)tree).identifier().name();
            }
            if (tree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                return ((IdentifierTree)tree).name();
            }
        }
        return null;
    }
}

