/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.filters;

import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.scan.issue.filter.FilterableIssue;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.check.Rule;
import org.sonar.java.checks.SuppressWarningsCheck;
import org.sonar.java.checks.helpers.ConstantUtils;
import org.sonar.java.filters.BaseTreeVisitorIssueFilter;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.SyntaxTrivia;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

public class SuppressWarningFilter
extends BaseTreeVisitorIssueFilter {
    private final Map<String, Multimap<String, Integer>> excludedLinesByComponent = new HashMap<String, Multimap<String, Integer>>();
    private static final String SUPPRESS_WARNING_RULE_KEY = SuppressWarningFilter.getSuppressWarningRuleKey();

    private static String getSuppressWarningRuleKey() {
        return ((Rule)AnnotationUtils.getAnnotation(SuppressWarningsCheck.class, Rule.class)).key();
    }

    @Override
    public Set<Class<? extends JavaCheck>> filteredRules() {
        return ImmutableSet.of();
    }

    @Override
    public void scanFile(JavaFileScannerContext context) {
        super.scanFile(context);
        this.excludedLinesByComponent.put(this.getComponentKey(), (Multimap<String, Integer>)HashMultimap.create(this.excludedLinesByRule()));
    }

    @Override
    public boolean accept(FilterableIssue issue) {
        Multimap<String, Integer> excludedLinesByRule = HashMultimap.create();
        if (this.excludedLinesByComponent.containsKey(issue.componentKey())) {
            excludedLinesByRule = this.excludedLinesByComponent.get(issue.componentKey());
        }
        return !SuppressWarningFilter.issueShouldNotBeReported(issue, excludedLinesByRule);
    }

    private static boolean issueShouldNotBeReported(FilterableIssue issue, Multimap<String, Integer> excludedLineByRule) {
        RuleKey issueRuleKey = issue.ruleKey();
        for (String excludedRule : excludedLineByRule.keySet()) {
            Collection excludedLines;
            if (!"all".equals(excludedRule) && !SuppressWarningFilter.isRuleKey(excludedRule, issueRuleKey) || SuppressWarningFilter.isSuppressWarningRule(issueRuleKey) || !(excludedLines = excludedLineByRule.get((Object)excludedRule)).contains(issue.line())) continue;
            return true;
        }
        return false;
    }

    private static boolean isRuleKey(String rule, RuleKey ruleKey) {
        try {
            return ruleKey.equals((Object)RuleKey.parse((String)rule));
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private static boolean isSuppressWarningRule(RuleKey ruleKey) {
        return SUPPRESS_WARNING_RULE_KEY.equals(ruleKey.rule());
    }

    public void visitClass(ClassTree tree) {
        this.handleSuppressWarning(tree.modifiers().annotations(), (Tree)tree);
        super.visitClass(tree);
    }

    public void visitMethod(MethodTree tree) {
        this.handleSuppressWarning(tree.modifiers().annotations(), (Tree)tree);
        super.visitMethod(tree);
    }

    public void visitVariable(VariableTree tree) {
        this.handleSuppressWarning(tree.modifiers().annotations(), (Tree)tree);
        super.visitVariable(tree);
    }

    private void handleSuppressWarning(List<AnnotationTree> annotationTrees, Tree tree) {
        int startLine = -1;
        ArrayList rules = Lists.newArrayList();
        for (AnnotationTree annotationTree : annotationTrees) {
            if (!SuppressWarningFilter.isSuppressWarningsAnnotation(annotationTree)) continue;
            startLine = SuppressWarningFilter.startLineIncludingTrivia(tree);
            rules.addAll(SuppressWarningFilter.getRules(annotationTree));
            break;
        }
        if (startLine != -1) {
            int endLine = tree.lastToken().line();
            ContiguousSet filteredlines = ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(startLine), (Comparable)Integer.valueOf(endLine)), (DiscreteDomain)DiscreteDomain.integers());
            for (String rule : rules) {
                this.excludeLines((Set<Integer>)filteredlines, rule);
            }
        }
    }

    private static int startLineIncludingTrivia(Tree tree) {
        SyntaxToken firstToken = tree.firstToken();
        if (!firstToken.trivias().isEmpty()) {
            return ((SyntaxTrivia)firstToken.trivias().get(0)).startLine();
        }
        return firstToken.line();
    }

    private static boolean isSuppressWarningsAnnotation(AnnotationTree annotationTree) {
        return annotationTree.annotationType().symbolType().is("java.lang.SuppressWarnings") && !annotationTree.arguments().isEmpty();
    }

    private static List<String> getRules(AnnotationTree annotationTree) {
        return SuppressWarningFilter.getRulesFromExpression((ExpressionTree)annotationTree.arguments().get(0));
    }

    private static List<String> getRulesFromExpression(ExpressionTree expression) {
        ArrayList args = Lists.newArrayList();
        if (expression.is(new Tree.Kind[]{Tree.Kind.NEW_ARRAY})) {
            for (ExpressionTree initializer : ((NewArrayTree)expression).initializers()) {
                args.addAll(SuppressWarningFilter.getRulesFromExpression(initializer));
            }
        } else {
            String constant = ConstantUtils.resolveAsStringConstant(expression);
            if (constant != null) {
                args.add(constant);
            }
        }
        return args;
    }
}

