/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2116")
public class ArrayHashCodeAndToStringCheck
extends AbstractMethodDetection {
    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return Arrays.asList(ArrayHashCodeAndToStringCheck.arrayMethodInvocation("toString"), ArrayHashCodeAndToStringCheck.arrayMethodInvocation("hashCode"));
    }

    private static MethodMatcher arrayMethodInvocation(String methodName) {
        return MethodMatcher.create().callSite(Type::isArray).name(methodName).withoutParameter();
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        String methodName = mit.symbol().name();
        this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)mit), "Use \"Arrays." + methodName + "(array)\" instead.");
    }
}

