/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.UnitTestUtils;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.MethodMatcherCollection;
import org.sonar.java.matcher.NameCriteria;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2970")
public class AssertionsCompletenessCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final String FEST_ASSERT_SUPERTYPE = "org.fest.assertions.Assert";
    private static final String ASSERTJ_SUPERTYPE = "org.assertj.core.api.AbstractAssert";
    private static final String TRUTH_SUPERTYPE = "com.google.common.truth.TestVerb";
    private static final String JAVA6_ABSTRACT_SOFT_ASSERT = "org.assertj.core.api.Java6AbstractStandardSoftAssertions";
    private static final MethodMatcher MOCKITO_VERIFY = MethodMatcher.create().typeDefinition("org.mockito.Mockito").name("verify").withAnyParameters();
    private static final MethodMatcherCollection ASSERTJ_ASSERT_ALL = MethodMatcherCollection.create((MethodMatcher[])new MethodMatcher[]{MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"org.assertj.core.api.SoftAssertions")).name("assertAll").withAnyParameters(), MethodMatcher.create().typeDefinition("org.assertj.core.api.Java6SoftAssertions").name("assertAll").withAnyParameters()});
    private static final MethodMatcher ASSERTJ_ASSERT_THAT = MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"org.assertj.core.api.AbstractSoftAssertions")).name(NameCriteria.startsWith((String)"assertThat")).withAnyParameters();
    private static final MethodMatcher ASSERTJ_ASSERT_SOFTLY = MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"org.assertj.core.api.SoftAssertions")).name("assertSoftly").withAnyParameters();
    private static final MethodMatcherCollection FEST_LIKE_ASSERT_THAT = MethodMatcherCollection.create((MethodMatcher[])new MethodMatcher[]{AssertionsCompletenessCheck.assertThatOnType("org.fest.assertions.Assertions"), AssertionsCompletenessCheck.assertThatOnType("org.fest.assertions.api.Assertions"), AssertionsCompletenessCheck.assertThatOnType("org.assertj.core.api.AbstractSoftAssertions"), AssertionsCompletenessCheck.assertThatOnType("org.assertj.core.api.Assertions"), AssertionsCompletenessCheck.assertThatOnType("org.assertj.core.api.Java6Assertions"), AssertionsCompletenessCheck.assertThatOnType("org.assertj.core.api.AbstractStandardSoftAssertions"), AssertionsCompletenessCheck.assertThatOnType("org.assertj.core.api.Java6AbstractStandardSoftAssertions"), AssertionsCompletenessCheck.assertThatOnType("org.assertj.core.api.StrictAssertions"), AssertionsCompletenessCheck.methodWithName("com.google.common.truth.Truth", NameCriteria.startsWith((String)"assert")), AssertionsCompletenessCheck.methodWithName("com.google.common.truth.Truth8", NameCriteria.startsWith((String)"assert"))});
    private static final MethodMatcherCollection FEST_LIKE_EXCLUSIONS = MethodMatcherCollection.create((MethodMatcher[])new MethodMatcher[]{AssertionsCompletenessCheck.methodWithName("org.fest.assertions.Assert", NameCriteria.startsWith((String)"as")), AssertionsCompletenessCheck.methodWithName("org.fest.assertions.Assert", NameCriteria.startsWith((String)"using")), AssertionsCompletenessCheck.methodWithName("org.fest.assertions.Assert", NameCriteria.startsWith((String)"with")), AssertionsCompletenessCheck.methodWithName("org.fest.assertions.Assert", NameCriteria.is((String)"describedAs")), AssertionsCompletenessCheck.methodWithName("org.fest.assertions.Assert", NameCriteria.is((String)"overridingErrorMessage")), AssertionsCompletenessCheck.methodWithName("org.assertj.core.api.AbstractAssert", NameCriteria.startsWith((String)"as")), AssertionsCompletenessCheck.methodWithName("org.assertj.core.api.AbstractAssert", NameCriteria.startsWith((String)"using")), AssertionsCompletenessCheck.methodWithName("org.assertj.core.api.AbstractAssert", NameCriteria.startsWith((String)"with")), AssertionsCompletenessCheck.methodWithName("org.assertj.core.api.AbstractAssert", NameCriteria.is((String)"describedAs")), AssertionsCompletenessCheck.methodWithName("org.assertj.core.api.AbstractAssert", NameCriteria.is((String)"overridingErrorMessage")), AssertionsCompletenessCheck.methodWithName("com.google.common.truth.TestVerb", NameCriteria.is((String)"that"))});
    private Boolean chainedToAnyMethodButFestExclusions = null;
    private JavaFileScannerContext context;

    private static MethodMatcher assertThatOnType(String type) {
        return MethodMatcher.create().typeDefinition(type).name("assertThat").addParameter(TypeCriteria.anyType());
    }

    private static MethodMatcher methodWithName(String superType, NameCriteria nameCriteria) {
        return MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)superType)).name(nameCriteria).withAnyParameters();
    }

    private static boolean isMethodCalledOnJava6AbstractStandardSoftAssertions(MethodInvocationTree mit) {
        Type type;
        ExpressionTree methodSelect = mit.methodSelect();
        return methodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && (type = ((MemberSelectExpressionTree)methodSelect).expression().symbolType()).is(JAVA6_ABSTRACT_SOFT_ASSERT);
    }

    public void scanFile(JavaFileScannerContext context) {
        if (context.getSemanticModel() == null) {
            return;
        }
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitVariable(VariableTree tree) {
    }

    public void visitReturnStatement(ReturnStatementTree tree) {
    }

    public void visitMethod(MethodTree methodTree) {
        if (ModifiersUtils.hasModifier((ModifiersTree)methodTree.modifiers(), (Modifier)Modifier.ABSTRACT)) {
            return;
        }
        super.visitMethod(methodTree);
        if (UnitTestUtils.hasTestAnnotation(methodTree)) {
            SoftAssertionsVisitor softAssertionsVisitor = new SoftAssertionsVisitor();
            methodTree.accept((TreeVisitor)softAssertionsVisitor);
            if (softAssertionsVisitor.assertThatCalled) {
                this.context.reportIssue((JavaCheck)this, (Tree)methodTree.block().closeBraceToken(), "Add a call to 'assertAll' after all 'assertThat'.");
            }
        }
    }

    public void visitMethodInvocation(MethodInvocationTree mit) {
        if (this.incompleteAssertion(mit)) {
            return;
        }
        Boolean previous = this.chainedToAnyMethodButFestExclusions;
        this.chainedToAnyMethodButFestExclusions = (Boolean)MoreObjects.firstNonNull((Object)this.chainedToAnyMethodButFestExclusions, (Object)false) != false || !FEST_LIKE_EXCLUSIONS.anyMatch(mit);
        this.scan((Tree)mit.methodSelect());
        this.chainedToAnyMethodButFestExclusions = previous;
    }

    private boolean incompleteAssertion(MethodInvocationTree mit) {
        if (AssertionsCompletenessCheck.isMethodCalledOnJava6AbstractStandardSoftAssertions(mit)) {
            return false;
        }
        if ((FEST_LIKE_ASSERT_THAT.anyMatch(mit) && mit.arguments().size() == 1 || MOCKITO_VERIFY.matches(mit)) && !Boolean.TRUE.equals(this.chainedToAnyMethodButFestExclusions)) {
            this.context.reportIssue((JavaCheck)this, (Tree)mit.methodSelect(), "Complete the assertion.");
            return true;
        }
        return false;
    }

    class SoftAssertionsVisitor
    extends BaseTreeVisitor {
        private boolean assertThatCalled;
        private final List<MethodInvocationTree> intermediateMethodInvocations;

        public SoftAssertionsVisitor() {
            this(false, Collections.emptyList());
        }

        public SoftAssertionsVisitor(boolean assertThatCalled, List<MethodInvocationTree> intermediateMethodInvocations) {
            this.assertThatCalled = assertThatCalled;
            this.intermediateMethodInvocations = intermediateMethodInvocations;
        }

        public void visitNewClass(NewClassTree tree) {
            if (tree.symbolType().is(AssertionsCompletenessCheck.JAVA6_ABSTRACT_SOFT_ASSERT)) {
                AssertionsCompletenessCheck.this.context.reportIssue((JavaCheck)AssertionsCompletenessCheck.this, (Tree)tree, "Use 'Java6SoftAssertions' instead of 'Java6AbstractStandardSoftAssertions'.");
                return;
            }
            super.visitNewClass(tree);
        }

        public void visitMethodInvocation(MethodInvocationTree mit) {
            if (AssertionsCompletenessCheck.isMethodCalledOnJava6AbstractStandardSoftAssertions(mit)) {
                return;
            }
            boolean assertThatStateBeforeInvocation = this.assertThatCalled;
            super.visitMethodInvocation(mit);
            if (ASSERTJ_ASSERT_SOFTLY.matches(mit)) {
                this.assertThatCalled = assertThatStateBeforeInvocation;
            }
            if (ASSERTJ_ASSERT_ALL.anyMatch(mit)) {
                if (this.assertThatCalled) {
                    this.assertThatCalled = false;
                } else {
                    List allLocations = Stream.concat(this.intermediateMethodInvocations.stream(), Stream.of(mit)).collect(Collectors.toList());
                    MethodInvocationTree mainLocation = (MethodInvocationTree)allLocations.get(0);
                    List secondaries = allLocations.stream().skip(1L).map(methodInvocation -> new JavaFileScannerContext.Location("", (Tree)methodInvocation.methodSelect())).collect(Collectors.toList());
                    AssertionsCompletenessCheck.this.context.reportIssue((JavaCheck)AssertionsCompletenessCheck.this, (Tree)mainLocation, "Add one or more 'assertThat' before 'assertAll'.", secondaries, null);
                }
            } else if (ASSERTJ_ASSERT_THAT.matches(mit) && !this.isJUnitSoftAssertions(mit)) {
                this.assertThatCalled = true;
            } else if (mit.symbol().declaration() != null && this.intermediateMethodInvocations.stream().noneMatch(intermediate -> intermediate.symbol().equals(mit.symbol()))) {
                List<MethodInvocationTree> allLocations = Stream.concat(this.intermediateMethodInvocations.stream(), Stream.of(mit)).collect(Collectors.toList());
                SoftAssertionsVisitor softAssertionsVisitor = new SoftAssertionsVisitor(this.assertThatCalled, allLocations);
                mit.symbol().declaration().accept((TreeVisitor)softAssertionsVisitor);
                this.assertThatCalled = softAssertionsVisitor.assertThatCalled;
            }
        }

        public void visitTryStatement(TryStatementTree tree) {
            boolean hasAutoCloseableSoftAssertion = tree.resourceList().stream().map(this::resourceSymbol).map(Symbol::type).filter(Objects::nonNull).anyMatch(type -> type.isSubtypeOf("org.assertj.core.api.AutoCloseableSoftAssertions"));
            super.visitTryStatement(tree);
            if (hasAutoCloseableSoftAssertion) {
                if (this.assertThatCalled) {
                    this.assertThatCalled = false;
                } else {
                    List secondaries = this.intermediateMethodInvocations.stream().map(methodInvocation -> new JavaFileScannerContext.Location("", (Tree)methodInvocation.methodSelect())).collect(Collectors.toList());
                    AssertionsCompletenessCheck.this.context.reportIssue((JavaCheck)AssertionsCompletenessCheck.this, (Tree)tree.block().closeBraceToken(), "Add one or more 'assertThat' before the end of this try block.", secondaries, null);
                }
            }
        }

        private Symbol resourceSymbol(Tree tree) {
            switch (tree.kind()) {
                case VARIABLE: {
                    return ((VariableTree)tree).symbol();
                }
                case IDENTIFIER: {
                    return ((IdentifierTree)tree).symbol();
                }
                case MEMBER_SELECT: {
                    return ((MemberSelectExpressionTree)tree).identifier().symbol();
                }
            }
            throw new IllegalArgumentException("Tree is not try-with-resources resource");
        }

        private boolean isJUnitSoftAssertions(MethodInvocationTree mit) {
            ExpressionTree expressionTree = mit.methodSelect();
            if (expressionTree.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                Type type = ((MemberSelectExpressionTree)expressionTree).expression().symbolType();
                return type.isSubtypeOf("org.assertj.core.api.JUnitSoftAssertions") || type.isSubtypeOf("org.assertj.core.api.Java6JUnitSoftAssertions");
            }
            return false;
        }
    }
}

