/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.Lists;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.NameCriteria;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2701")
public class BooleanLiteralInAssertionsCheck
extends AbstractMethodDetection {
    private static final String ASSERT = "assert";

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return Lists.newArrayList((Object[])new MethodMatcher[]{MethodMatcher.create().typeDefinition("org.junit.Assert").name(NameCriteria.startsWith((String)ASSERT)).withAnyParameters(), MethodMatcher.create().typeDefinition("org.junit.jupiter.api.Assertions").name(NameCriteria.startsWith((String)ASSERT)).withAnyParameters(), MethodMatcher.create().typeDefinition("junit.framework.Assert").name(NameCriteria.startsWith((String)ASSERT)).withAnyParameters(), MethodMatcher.create().typeDefinition("junit.framework.TestCase").name(NameCriteria.startsWith((String)ASSERT)).withAnyParameters(), MethodMatcher.create().typeDefinition("org.fest.assertions.Assertions").name("assertThat").addParameter("boolean")});
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        int arity = mit.arguments().size();
        for (int i = 0; i < arity; ++i) {
            ExpressionTree booleanArg = (ExpressionTree)mit.arguments().get(i);
            if (!booleanArg.is(new Tree.Kind[]{Tree.Kind.BOOLEAN_LITERAL})) continue;
            this.reportIssue((Tree)booleanArg, "Remove or correct this assertion.");
            break;
        }
    }
}

