/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.JUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S1699")
public class ConstructorCallingOverridableCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CONSTRUCTOR);
    }

    public void visitNode(Tree tree) {
        MethodTree m;
        Symbol.TypeSymbol constructorType;
        if (this.hasSemantic() && !(constructorType = (m = (MethodTree)tree).symbol().enclosingClass()).isFinal()) {
            ((MethodTree)tree).block().accept((TreeVisitor)new ConstructorBodyVisitor(constructorType));
        }
    }

    private class ConstructorBodyVisitor
    extends BaseTreeVisitor {
        private Symbol.TypeSymbol constructorType;

        public ConstructorBodyVisitor(Symbol.TypeSymbol constructorType) {
            this.constructorType = constructorType;
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            Symbol symbol;
            IdentifierTree methodIdentifier = null;
            boolean isInvocationOnSelf = false;
            ExpressionTree methodSelect = tree.methodSelect();
            if (methodSelect.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                methodIdentifier = (IdentifierTree)methodSelect;
                isInvocationOnSelf = !this.isThisOrSuper((ExpressionTree)methodIdentifier);
            } else if (methodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                MemberSelectExpressionTree memberSelect = (MemberSelectExpressionTree)methodSelect;
                methodIdentifier = memberSelect.identifier();
                isInvocationOnSelf = this.isThis(memberSelect.expression());
            }
            if (isInvocationOnSelf && (symbol = methodIdentifier.symbol()).isMethodSymbol() && JUtils.isOverridable((Symbol.MethodSymbol)((Symbol.MethodSymbol)symbol)) && this.isMethodDefinedOnConstructedType(symbol)) {
                ConstructorCallingOverridableCheck.this.reportIssue((Tree)methodIdentifier, "Remove this call from a constructor to the overridable \"" + methodIdentifier.name() + "\" method.");
            }
            super.visitMethodInvocation(tree);
        }

        public void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree) {
        }

        public void visitNewClass(NewClassTree tree) {
        }

        private boolean is(ExpressionTree expression, String match) {
            if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                String targetName = ((IdentifierTree)expression).name();
                return match.equals(targetName);
            }
            return false;
        }

        private boolean isThis(ExpressionTree expression) {
            return this.is(expression, "this");
        }

        private boolean isThisOrSuper(ExpressionTree expression) {
            return this.is(expression, "this") || this.is(expression, "super");
        }

        private boolean isMethodDefinedOnConstructedType(Symbol symbol) {
            Type typeDefiningMethod = symbol.enclosingClass().type().erasure();
            for (Type superType : JUtils.superTypes((Symbol.TypeSymbol)this.constructorType)) {
                if (!superType.erasure().equals(typeDefiningMethod)) continue;
                return true;
            }
            return this.constructorType.type().erasure().equals(typeDefiningMethod);
        }
    }
}

