/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.JavaVersionAwareVisitor;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2143")
public class DateAndTimesCheck
extends AbstractMethodDetection
implements JavaVersionAwareVisitor {
    private static final List<MethodMatcher> METHOD_MATCHERS = Arrays.asList(MethodMatcher.create().typeDefinition("java.util.Calendar").name("getInstance").withAnyParameters(), MethodMatcher.create().typeDefinition("java.util.Date").name("<init>").withAnyParameters());

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return METHOD_MATCHERS;
    }

    @Override
    protected void onConstructorFound(NewClassTree newClassTree) {
        this.reportIssue((Tree)newClassTree);
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        this.reportIssue((Tree)mit);
    }

    private void reportIssue(Tree tree) {
        this.reportIssue(tree, "Use the Java 8 Date and Time API instead." + this.context.getJavaVersion().java8CompatibilityMessage());
    }

    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava8Compatible();
    }
}

