/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3986")
public class DateFormatWeekYearCheck
extends AbstractMethodDetection {
    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return Collections.singletonList(MethodMatcher.create().typeDefinition("java.text.SimpleDateFormat").name("<init>").withAnyParameters());
    }

    @Override
    protected void onConstructorFound(NewClassTree newClassTree) {
        int start;
        if (newClassTree.arguments().isEmpty()) {
            return;
        }
        ExpressionTree expressionTree = (ExpressionTree)newClassTree.arguments().get(0);
        if (!expressionTree.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            return;
        }
        String datePattern = LiteralUtils.trimQuotes((String)((LiteralTree)expressionTree).value());
        if (!StringUtils.contains((String)datePattern, (char)'w') && (start = datePattern.indexOf(89)) > -1) {
            int end;
            for (end = start; end < datePattern.length() && datePattern.charAt(end) == 'Y'; ++end) {
            }
            String firstYseq = datePattern.substring(start, end);
            this.reportIssue((Tree)expressionTree, "Make sure that Week Year \"" + firstYseq + "\" is expected here instead of Year \"" + firstYseq.toLowerCase() + "\".");
        }
    }
}

