/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4011")
public class DisallowedConstructorCheck
extends AbstractMethodDetection {
    @RuleProperty(key="className", description="Name of the class whose constructor is forbidden. This parameter is mandatory, if absent the rule is disabled.")
    private String className = "";
    @RuleProperty(key="argumentTypes", description="Comma-delimited list of argument types, E.G. java.lang.String, int[], int")
    private String argumentTypes = "";
    @RuleProperty(key="allOverloads", description="Set to true to flag all overloads regardless of parameter type", defaultValue="false")
    private boolean allOverloads = false;

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        MethodMatcher invocationMatcher = MethodMatcher.create().name("<init>");
        if (StringUtils.isEmpty((String)this.className)) {
            return Collections.emptyList();
        }
        invocationMatcher.typeDefinition(this.className);
        if (this.allOverloads) {
            invocationMatcher.withAnyParameters();
        } else {
            String[] args = StringUtils.split((String)this.argumentTypes, (String)",");
            if (args.length == 0) {
                invocationMatcher.withoutParameter();
            } else {
                for (String arg : args) {
                    invocationMatcher.addParameter(StringUtils.trim((String)arg));
                }
            }
        }
        return Collections.singletonList(invocationMatcher);
    }

    @Override
    protected void onConstructorFound(NewClassTree newClassTree) {
        this.reportIssue((Tree)newClassTree.identifier(), "Remove this forbidden initialization");
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setArgumentTypes(String argumentTypes) {
        this.argumentTypes = argumentTypes;
    }

    public void setAllOverloads(boolean allOverloads) {
        this.allOverloads = allOverloads;
    }
}

