/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3599")
public class DoubleBraceInitializationCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.NEW_CLASS);
    }

    public void visitNode(Tree tree) {
        List members;
        ClassTree classBody = ((NewClassTree)tree).classBody();
        if (classBody != null && (members = classBody.members()).size() == 1 && ((Tree)members.get(0)).is(new Tree.Kind[]{Tree.Kind.INITIALIZER})) {
            this.reportIssue((Tree)classBody, "Use another way to initialize this instance.");
        }
    }
}

