/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.JUtils;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1640")
public class EnumMapCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;
    private static final String JAVA_UTIL_MAP = "java.util.Map";
    private static final MethodMatcher mapPut = MethodMatcher.create().typeDefinition("java.util.Map").name("put").withAnyParameters();

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitVariable(VariableTree tree) {
        if (tree.type().symbolType().isSubtypeOf(JAVA_UTIL_MAP)) {
            ExpressionTree initializer = tree.initializer();
            if (initializer != null && !EnumMapCheck.usesNullKey(tree.symbol())) {
                this.checkNewMap(initializer, EnumMapCheck.hasEnumKey(tree.type().symbolType()));
            }
        } else {
            super.visitVariable(tree);
        }
    }

    private static boolean usesNullKey(Symbol symbol) {
        List usages = symbol.usages();
        for (IdentifierTree usage : usages) {
            MethodInvocationTree mit;
            if (!usage.parent().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) || !usage.parent().parent().is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) || !mapPut.matches(mit = (MethodInvocationTree)usage.parent().parent()) || !((ExpressionTree)mit.arguments().get(0)).is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL})) continue;
            return true;
        }
        return false;
    }

    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        if (tree.variable().symbolType().isSubtypeOf(JAVA_UTIL_MAP)) {
            this.checkNewMap(tree.expression(), EnumMapCheck.hasEnumKey(tree.variable().symbolType()));
        } else {
            super.visitAssignmentExpression(tree);
        }
    }

    public void visitNewClass(NewClassTree tree) {
        if (EnumMapCheck.isUnorderedMap(tree.symbolType()) && EnumMapCheck.hasEnumKey(tree.identifier().symbolType())) {
            this.addIssue((Tree)tree);
        } else {
            super.visitNewClass(tree);
        }
    }

    private void checkNewMap(ExpressionTree given, boolean useEnumKey) {
        NewClassTree newClassTree;
        ExpressionTree expression = ExpressionUtils.skipParentheses((ExpressionTree)given);
        if (expression.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS}) && EnumMapCheck.isUnorderedMap((newClassTree = (NewClassTree)expression).symbolType()) && (useEnumKey || EnumMapCheck.hasEnumKey(newClassTree.identifier().symbolType()))) {
            this.addIssue((Tree)newClassTree);
        }
    }

    private static boolean isUnorderedMap(Type type) {
        return type.isSubtypeOf("java.util.HashMap") && !type.isSubtypeOf("java.util.LinkedHashMap");
    }

    private static boolean hasEnumKey(Type symbolType) {
        Type type = symbolType;
        if (JUtils.isParametrized((Type)type)) {
            return ((Type)JUtils.typeArguments((Type)type).get(0)).symbol().isEnum();
        }
        return false;
    }

    private void addIssue(Tree typeTree) {
        this.context.reportIssue((JavaCheck)this, typeTree, "Convert this Map to an EnumMap.");
    }
}

