/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.MethodTreeUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;

@Rule(key="S1206")
public class EqualsOverridenWithHashCodeCheck
extends IssuableSubscriptionVisitor {
    private static final String HASHCODE = "hashCode";
    private static final String EQUALS = "equals";

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        List methods = ((ClassTree)tree).members().stream().filter(member -> member.is(new Tree.Kind[]{Tree.Kind.METHOD})).map(member -> (MethodTree)member).collect(Collectors.toList());
        Optional<MethodTree> equalsMethod = methods.stream().filter(EqualsOverridenWithHashCodeCheck::isEquals).findAny();
        Optional<MethodTree> hashCodeMethod = methods.stream().filter(EqualsOverridenWithHashCodeCheck::isHashCode).findAny();
        if (equalsMethod.isPresent() && !hashCodeMethod.isPresent()) {
            this.reportIssue((Tree)equalsMethod.get().simpleName(), EqualsOverridenWithHashCodeCheck.getMessage(EQUALS, HASHCODE));
        } else if (hashCodeMethod.isPresent() && !equalsMethod.isPresent()) {
            this.reportIssue((Tree)hashCodeMethod.get().simpleName(), EqualsOverridenWithHashCodeCheck.getMessage(HASHCODE, EQUALS));
        }
    }

    private static boolean isEquals(MethodTree methodTree) {
        return MethodTreeUtils.isEqualsMethod(methodTree);
    }

    private static boolean isHashCode(MethodTree methodTree) {
        return HASHCODE.equals(methodTree.simpleName().name()) && methodTree.parameters().isEmpty() && EqualsOverridenWithHashCodeCheck.returnsInt(methodTree);
    }

    private static boolean returnsInt(MethodTree tree) {
        TypeTree typeTree = tree.returnType();
        return typeTree != null && typeTree.symbolType().isPrimitive(Type.Primitives.INT);
    }

    private static String getMessage(String overridenMethod, String methodToOverride) {
        return "This class overrides \"" + overridenMethod + "()\" and should therefore also override \"" + methodToOverride + "()\".";
    }
}

