/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.helpers.MethodTreeUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1067")
public class ExpressionComplexityCheck
extends IssuableSubscriptionVisitor {
    private static final int DEFAULT_MAX = 3;
    @RuleProperty(description="Maximum number of allowed conditional operators in an expression", defaultValue="3")
    public int max = 3;
    private final Deque<Integer> count = new LinkedList<Integer>();
    private final Deque<Integer> level = new LinkedList<Integer>();

    public void setContext(JavaFileScannerContext context) {
        this.count.clear();
        this.level.clear();
        this.level.push(0);
        this.count.push(0);
        super.setContext(context);
    }

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.CLASS, Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.POSTFIX_DECREMENT, Tree.Kind.PREFIX_INCREMENT, Tree.Kind.PREFIX_DECREMENT, Tree.Kind.UNARY_PLUS, Tree.Kind.UNARY_MINUS, Tree.Kind.BITWISE_COMPLEMENT, Tree.Kind.LOGICAL_COMPLEMENT, Tree.Kind.MULTIPLY, Tree.Kind.DIVIDE, Tree.Kind.REMAINDER, Tree.Kind.PLUS, Tree.Kind.MINUS, Tree.Kind.LEFT_SHIFT, Tree.Kind.RIGHT_SHIFT, Tree.Kind.UNSIGNED_RIGHT_SHIFT, Tree.Kind.LESS_THAN, Tree.Kind.GREATER_THAN, Tree.Kind.LESS_THAN_OR_EQUAL_TO, Tree.Kind.GREATER_THAN_OR_EQUAL_TO, Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO, Tree.Kind.AND, Tree.Kind.XOR, Tree.Kind.OR, Tree.Kind.CONDITIONAL_AND, Tree.Kind.CONDITIONAL_OR, Tree.Kind.CONDITIONAL_EXPRESSION, Tree.Kind.ARRAY_ACCESS_EXPRESSION, Tree.Kind.MEMBER_SELECT, Tree.Kind.NEW_CLASS, Tree.Kind.NEW_ARRAY, Tree.Kind.METHOD_INVOCATION, Tree.Kind.TYPE_CAST, Tree.Kind.INSTANCE_OF, Tree.Kind.PARENTHESIZED_EXPRESSION, Tree.Kind.ASSIGNMENT, Tree.Kind.MULTIPLY_ASSIGNMENT, Tree.Kind.DIVIDE_ASSIGNMENT, Tree.Kind.REMAINDER_ASSIGNMENT, Tree.Kind.PLUS_ASSIGNMENT, Tree.Kind.MINUS_ASSIGNMENT, Tree.Kind.LEFT_SHIFT_ASSIGNMENT, Tree.Kind.RIGHT_SHIFT_ASSIGNMENT, Tree.Kind.UNSIGNED_RIGHT_SHIFT_ASSIGNMENT, Tree.Kind.AND_ASSIGNMENT, Tree.Kind.XOR_ASSIGNMENT, Tree.Kind.OR_ASSIGNMENT, Tree.Kind.INT_LITERAL, Tree.Kind.LONG_LITERAL, Tree.Kind.FLOAT_LITERAL, Tree.Kind.DOUBLE_LITERAL, Tree.Kind.BOOLEAN_LITERAL, Tree.Kind.CHAR_LITERAL, Tree.Kind.STRING_LITERAL, Tree.Kind.NULL_LITERAL, Tree.Kind.IDENTIFIER, Tree.Kind.ARRAY_TYPE, Tree.Kind.LAMBDA_EXPRESSION, Tree.Kind.PRIMITIVE_TYPE);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.CLASS, Tree.Kind.NEW_ARRAY}) || ExpressionComplexityCheck.isLambdaWithBlock(tree)) {
            this.count.push(0);
            this.level.push(0);
        } else {
            if (tree.is(new Tree.Kind[]{Tree.Kind.CONDITIONAL_OR}) || tree.is(new Tree.Kind[]{Tree.Kind.CONDITIONAL_AND}) || tree.is(new Tree.Kind[]{Tree.Kind.CONDITIONAL_EXPRESSION})) {
                this.count.push(this.count.pop() + 1);
            }
            this.level.push(this.level.pop() + 1);
        }
    }

    public void leaveNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.CLASS, Tree.Kind.NEW_ARRAY}) || ExpressionComplexityCheck.isLambdaWithBlock(tree)) {
            this.count.pop();
            this.level.pop();
        } else {
            int currentLevel = this.level.peek();
            if (currentLevel == 1) {
                int opCount = this.count.pop();
                if (opCount > this.max && !ExpressionComplexityCheck.isInsideEquals(tree)) {
                    this.reportIssue(tree, "Reduce the number of conditional operators (" + opCount + ") used in the expression (maximum allowed " + this.max + ").", Collections.emptyList(), opCount - this.max);
                }
                this.count.push(0);
            }
            this.level.push(this.level.pop() - 1);
        }
    }

    private static boolean isInsideEquals(Tree tree) {
        for (Tree parent = tree.parent(); parent != null && !parent.is(new Tree.Kind[]{Tree.Kind.CLASS}); parent = parent.parent()) {
            if (!parent.is(new Tree.Kind[]{Tree.Kind.METHOD}) || !MethodTreeUtils.isEqualsMethod((MethodTree)parent)) continue;
            return true;
        }
        return false;
    }

    private static boolean isLambdaWithBlock(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.LAMBDA_EXPRESSION}) && ((LambdaExpressionTree)tree).body().is(new Tree.Kind[]{Tree.Kind.BLOCK});
    }
}

