/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1215")
public class GarbageCollectorCalledCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        MemberSelectExpressionTree mset;
        MethodInvocationTree mit = (MethodInvocationTree)tree;
        if (mit.arguments().isEmpty() && mit.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && GarbageCollectorCalledCheck.isGarbageCollectorCall(mset = (MemberSelectExpressionTree)mit.methodSelect())) {
            this.reportIssue((Tree)mset.identifier(), "Don't try to be smarter than the JVM, remove this call to run the garbage collector.");
        }
    }

    private static boolean isGarbageCollectorCall(MemberSelectExpressionTree mset) {
        if ("gc".equals(mset.identifier().name())) {
            MethodInvocationTree mit;
            if (mset.expression().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                return "System".equals(((IdentifierTree)mset.expression()).name());
            }
            if (mset.expression().is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && (mit = (MethodInvocationTree)mset.expression()).arguments().isEmpty() && mit.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                MemberSelectExpressionTree subMset = (MemberSelectExpressionTree)mit.methodSelect();
                return "getRuntime".equals(subMset.identifier().name()) && subMset.expression().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && "Runtime".equals(((IdentifierTree)subMset.expression()).name());
            }
        }
        return false;
    }
}

