/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.MethodMatcherCollection;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.PrimitiveTypeTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1185")
public class MethodOnlyCallsSuperCheck
extends IssuableSubscriptionVisitor {
    private static final String JAVA_LANG_OBJECT = "java.lang.Object";
    private static final MethodMatcherCollection ALLOWED_METHODS = MethodMatcherCollection.create((MethodMatcher[])new MethodMatcher[]{MethodMatcher.create().name("toString").typeDefinition(TypeCriteria.anyType()).withoutParameter(), MethodMatcher.create().name("hashCode").typeDefinition(TypeCriteria.anyType()).withoutParameter(), MethodMatcher.create().name("equals").typeDefinition(TypeCriteria.anyType()).parameters(new String[]{"java.lang.Object"})});

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        MethodTree methodTree = (MethodTree)tree;
        if (ALLOWED_METHODS.anyMatch(methodTree)) {
            return;
        }
        if (MethodOnlyCallsSuperCheck.isSingleStatementMethod(methodTree) && MethodOnlyCallsSuperCheck.isUselessSuperCall(methodTree) && !MethodOnlyCallsSuperCheck.hasAnnotationDifferentFromOverride(methodTree.modifiers().annotations()) && !MethodOnlyCallsSuperCheck.isFinal(methodTree)) {
            this.reportIssue((Tree)methodTree.simpleName(), "Remove this method to simply inherit it.");
        }
    }

    private static boolean isFinal(MethodTree methodTree) {
        return ModifiersUtils.hasModifier((ModifiersTree)methodTree.modifiers(), (Modifier)Modifier.FINAL);
    }

    private static boolean isSingleStatementMethod(MethodTree methodTree) {
        BlockTree block = methodTree.block();
        return block != null && block.body().size() == 1;
    }

    private static boolean isUselessSuperCall(MethodTree methodTree) {
        ExpressionTree callToSuper = null;
        StatementTree statementTree = (StatementTree)methodTree.block().body().get(0);
        if (MethodOnlyCallsSuperCheck.returnsVoid(methodTree) && statementTree.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STATEMENT})) {
            callToSuper = ((ExpressionStatementTree)statementTree).expression();
        } else if (statementTree.is(new Tree.Kind[]{Tree.Kind.RETURN_STATEMENT})) {
            callToSuper = ((ReturnStatementTree)statementTree).expression();
        }
        return callToSuper != null && MethodOnlyCallsSuperCheck.isCallToSuper(methodTree, (Tree)callToSuper) && MethodOnlyCallsSuperCheck.sameVisibility(methodTree.symbol(), ((MethodInvocationTree)callToSuper).symbol());
    }

    private static boolean sameVisibility(Symbol.MethodSymbol method, Symbol parentMethod) {
        if (parentMethod.isUnknown()) {
            return true;
        }
        return MethodOnlyCallsSuperCheck.bothPackage(method, parentMethod) || MethodOnlyCallsSuperCheck.bothProtected(method, parentMethod) || MethodOnlyCallsSuperCheck.bothPublic(method, parentMethod);
    }

    private static boolean bothPackage(Symbol.MethodSymbol method, Symbol parentMethod) {
        return method.isPackageVisibility() && parentMethod.isPackageVisibility();
    }

    private static boolean bothProtected(Symbol.MethodSymbol method, Symbol parentMethod) {
        return method.isProtected() && parentMethod.isProtected();
    }

    private static boolean bothPublic(Symbol.MethodSymbol method, Symbol parentMethod) {
        return method.isPublic() && parentMethod.isPublic();
    }

    private static boolean isCallToSuper(MethodTree methodTree, Tree callToSuper) {
        MemberSelectExpressionTree mset;
        MethodInvocationTree methodInvocationTree;
        return callToSuper.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && (methodInvocationTree = (MethodInvocationTree)callToSuper).methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && MethodOnlyCallsSuperCheck.callSuperMethodWithSameName(mset = (MemberSelectExpressionTree)methodInvocationTree.methodSelect(), methodTree) && MethodOnlyCallsSuperCheck.callsWithSameParameters((List<ExpressionTree>)methodInvocationTree.arguments(), methodTree.parameters());
    }

    private static boolean callSuperMethodWithSameName(MemberSelectExpressionTree mset, MethodTree methodTree) {
        return mset.expression().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && "super".equals(((IdentifierTree)mset.expression()).name()) && mset.identifier().name().equals(methodTree.simpleName().name());
    }

    private static boolean callsWithSameParameters(List<ExpressionTree> arguments, List<VariableTree> parameters) {
        if (arguments.size() != parameters.size()) {
            return false;
        }
        for (int i = 0; i < arguments.size(); ++i) {
            ExpressionTree arg = arguments.get(i);
            VariableTree param = parameters.get(i);
            if (arg.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && ((IdentifierTree)arg).name().equals(param.simpleName().name())) continue;
            return false;
        }
        return true;
    }

    private static boolean returnsVoid(MethodTree methodTree) {
        TypeTree returnType = methodTree.returnType();
        return returnType != null && returnType.is(new Tree.Kind[]{Tree.Kind.PRIMITIVE_TYPE}) && "void".equals(((PrimitiveTypeTree)returnType).keyword().text());
    }

    private static boolean hasAnnotationDifferentFromOverride(List<AnnotationTree> annotations) {
        for (AnnotationTree annotation : annotations) {
            if (annotation.annotationType().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && "Override".equals(((IdentifierTree)annotation.annotationType()).name())) continue;
            return true;
        }
        return false;
    }
}

