/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.MethodMatcherCollection;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.java.model.JUtils;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2131")
public class PrimitiveTypeBoxingWithToStringCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final MethodMatcherCollection TO_STRING_MATCHERS = PrimitiveTypeBoxingWithToStringCheck.getToStringMatchers("java.lang.Byte", "java.lang.Character", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "java.lang.Float", "java.lang.Double", "java.lang.Boolean");
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    private static MethodMatcherCollection getToStringMatchers(String ... typeFullyQualifiedNames) {
        MethodMatcherCollection matchers = MethodMatcherCollection.create((MethodMatcher[])new MethodMatcher[0]);
        for (String fullyQualifiedName : typeFullyQualifiedNames) {
            matchers.add(MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)fullyQualifiedName)).name("toString").withoutParameter());
        }
        return matchers;
    }

    public void visitMethodInvocation(MethodInvocationTree tree) {
        ExpressionTree abstractTypedTree;
        if (TO_STRING_MATCHERS.anyMatch(tree) && ((abstractTypedTree = ((MemberSelectExpressionTree)tree.methodSelect()).expression()).is(new Tree.Kind[]{Tree.Kind.NEW_CLASS}) || PrimitiveTypeBoxingWithToStringCheck.isValueOfInvocation(abstractTypedTree))) {
            String typeName = abstractTypedTree.symbolType().toString();
            this.createIssue((Tree)tree, typeName);
        }
        super.visitMethodInvocation(tree);
    }

    private void createIssue(Tree reportingTree, String wrapperName) {
        this.context.reportIssue((JavaCheck)this, reportingTree, "Use \"" + wrapperName + ".toString\" instead.");
    }

    public void visitAnnotation(AnnotationTree annotationTree) {
        this.scan((Tree)annotationTree.annotationType());
    }

    private static boolean isValueOfInvocation(ExpressionTree abstractTypedTree) {
        if (!abstractTypedTree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            return false;
        }
        Type type = abstractTypedTree.symbolType();
        MethodMatcher valueOfMatcher = MethodMatcher.create().typeDefinition(type.fullyQualifiedName()).name("valueOf").addParameter(JUtils.primitiveType((Type)type).fullyQualifiedName());
        return valueOfMatcher.matches((MethodInvocationTree)abstractTypedTree);
    }
}

