/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.checks.AbstractPrintfChecker;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.MethodMatcherCollection;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S3457")
public class PrintfMisuseCheck
extends AbstractPrintfChecker {
    private static final MethodMatcher TO_STRING = MethodMatcher.create().typeDefinition(TypeCriteria.anyType()).name("toString").withoutParameter();
    private static final MethodMatcherCollection GET_LOGGER = MethodMatcherCollection.create((MethodMatcher[])new MethodMatcher[]{MethodMatcher.create().typeDefinition("java.util.logging.Logger").name("getLogger").parameters(new String[]{"java.lang.String", "java.lang.String"}), MethodMatcher.create().typeDefinition("java.util.logging.Logger").name("getAnonymousLogger").parameters(new String[]{"java.lang.String"})});

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        boolean isMessageFormat = MESSAGE_FORMAT.matches(mit);
        if (isMessageFormat && !mit.symbol().isStatic()) {
            return;
        }
        if (!isMessageFormat && (isMessageFormat = JAVA_UTIL_LOGGER_LOG_MATCHER.anyMatch(mit)) && PrintfMisuseCheck.hasResourceBundle(mit)) {
            return;
        }
        if (!isMessageFormat) {
            isMessageFormat = PrintfMisuseCheck.isLoggingMethod(mit);
        }
        super.checkFormatting(mit, isMessageFormat);
    }

    private static boolean hasResourceBundle(MethodInvocationTree mit) {
        VariableTree var;
        ExpressionTree init;
        Tree decl;
        if (!mit.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            return false;
        }
        ExpressionTree id = ((MemberSelectExpressionTree)mit.methodSelect()).expression();
        if (id.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            id = ((MemberSelectExpressionTree)id).identifier();
        }
        if (id.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && (decl = ((IdentifierTree)id).symbol().declaration()) != null && decl.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) && (init = (var = (VariableTree)decl).initializer()) != null && init.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            return GET_LOGGER.anyMatch((MethodInvocationTree)init);
        }
        return false;
    }

    @Override
    protected void handlePrintfFormat(MethodInvocationTree mit, String formatString, List<ExpressionTree> args) {
        List<String> params = this.getParameters(formatString, mit);
        if (PrintfMisuseCheck.usesMessageFormat(formatString, params)) {
            this.reportIssue((Tree)mit, "Looks like there is a confusion with the use of java.text.MessageFormat, parameters will be simply ignored here");
            return;
        }
        this.checkLineFeed(formatString, mit);
        if (!(!params.isEmpty() || args.isEmpty() && PrintfMisuseCheck.isLoggingMethod(mit))) {
            this.reportIssue((Tree)mit, "String contains no format specifiers.");
            return;
        }
        PrintfMisuseCheck.cleanupLineSeparator(params);
        if (!params.isEmpty() && PrintfMisuseCheck.argIndexes(params).size() <= args.size()) {
            this.verifyParameters(mit, args, params);
        }
    }

    private void verifyParameters(MethodInvocationTree mit, List<ExpressionTree> args, List<String> params) {
        int index = 0;
        ArrayList<ExpressionTree> unusedArgs = new ArrayList<ExpressionTree>(args);
        Iterator<String> iterator = params.iterator();
        while (iterator.hasNext()) {
            String rawParam;
            String param = rawParam = iterator.next();
            int argIndex = index++;
            if (param.contains("$")) {
                argIndex = PrintfMisuseCheck.getIndex(param) - 1;
                if (argIndex == -1) {
                    return;
                }
                param = param.substring(param.indexOf(36) + 1);
            } else if (param.charAt(0) == '<') {
                argIndex = Math.max(0, argIndex - 1);
            }
            if (argIndex >= args.size()) {
                return;
            }
            ExpressionTree argExpressionTree = args.get(argIndex);
            unusedArgs.remove(argExpressionTree);
            Type argType = argExpressionTree.symbolType();
            this.checkBoolean(mit, param, argType);
        }
        this.reportUnusedArgs(mit, args, unusedArgs);
    }

    @Override
    protected void handleMessageFormat(MethodInvocationTree mit, String formatString, List<ExpressionTree> args) {
        String newFormatString = PrintfMisuseCheck.cleanupDoubleQuote(formatString);
        Set<Integer> indexes = PrintfMisuseCheck.getMessageFormatIndexes(newFormatString, mit);
        List<ExpressionTree> transposedArgs = PrintfMisuseCheck.transposeArgumentArrayAndRemoveThrowable(mit, args);
        if (transposedArgs == null) {
            return;
        }
        if (indexes.isEmpty() && !transposedArgs.isEmpty()) {
            this.reportIssue((Tree)mit, "String contains no format specifiers.");
            return;
        }
        this.checkToStringInvocation(transposedArgs);
        this.verifyParameters(mit, transposedArgs, indexes);
    }

    private void checkToStringInvocation(List<ExpressionTree> args) {
        args.stream().filter(arg -> arg.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})).map(MethodInvocationTree.class::cast).filter(arg_0 -> ((MethodMatcher)TO_STRING).matches(arg_0)).filter(arg -> arg != args.get(args.size() - 1) || !PrintfMisuseCheck.isMethodOfThrowable(arg)).forEach(arg -> this.reportIssue((Tree)arg, PrintfMisuseCheck.getToStringMessage((ExpressionTree)arg)));
    }

    private static boolean isMethodOfThrowable(MethodInvocationTree argument) {
        Symbol owner = argument.symbol().owner();
        return owner != null && owner.type().isSubtypeOf("java.lang.Throwable");
    }

    private static String getToStringMessage(ExpressionTree arg) {
        if (PrintfMisuseCheck.isInStringArrayInitializer(arg)) {
            return "No need to call \"toString()\" method since an array of Objects can be used here.";
        }
        return "No need to call \"toString()\" method as formatting and string conversion is done by the Formatter.";
    }

    private static boolean isInStringArrayInitializer(ExpressionTree arg) {
        return Optional.of(arg).map(Tree::parent).filter(tree -> tree.is(new Tree.Kind[]{Tree.Kind.LIST})).map(Tree::parent).filter(tree -> tree.is(new Tree.Kind[]{Tree.Kind.NEW_ARRAY})).map(NewArrayTree.class::cast).map(ExpressionTree::symbolType).filter(Type::isArray).map(Type.ArrayType.class::cast).map(Type.ArrayType::elementType).filter(type -> type.is("java.lang.String")).isPresent();
    }

    private void verifyParameters(MethodInvocationTree mit, List<ExpressionTree> args, Set<Integer> indexes) {
        ArrayList<ExpressionTree> unusedArgs = new ArrayList<ExpressionTree>(args);
        for (int index : indexes) {
            if (index >= args.size()) {
                return;
            }
            unusedArgs.remove(args.get(index));
        }
        this.reportUnusedArgs(mit, args, unusedArgs);
    }

    private void reportUnusedArgs(MethodInvocationTree mit, List<ExpressionTree> args, List<ExpressionTree> unusedArgs) {
        for (ExpressionTree unusedArg : unusedArgs) {
            int i = args.indexOf(unusedArg);
            this.reportIssue((Tree)mit, PrintfMisuseCheck.postFixedIndex(i) + " argument is not used.");
        }
    }

    private static String postFixedIndex(int i) {
        if (i < 1) {
            return "first";
        }
        if (i < 2) {
            return "2nd";
        }
        if (i < 3) {
            return "3rd";
        }
        return i + 1 + "th";
    }

    private void checkBoolean(MethodInvocationTree mit, String param, Type argType) {
        if (param.charAt(0) == 'b' && !argType.is("boolean") && !argType.is("java.lang.Boolean")) {
            this.reportIssue((Tree)mit, "Directly inject the boolean value.");
        }
    }

    private void checkLineFeed(String formatString, MethodInvocationTree mit) {
        if (formatString.contains("\\n")) {
            this.reportIssue((Tree)mit, "%n should be used in place of \\n to produce the platform-specific line separator.");
        }
    }

    private static boolean usesMessageFormat(String formatString, List<String> params) {
        return params.isEmpty() && (formatString.contains("{0") || formatString.contains("{1"));
    }

    @Override
    protected void handleOtherFormatTree(MethodInvocationTree mit, ExpressionTree formatTree, List<ExpressionTree> args) {
        if (PrintfMisuseCheck.isIncorrectConcatenation(formatTree)) {
            if (JAVA_UTIL_LOGGER_LOG_MATCHER.anyMatch(mit)) {
                if (PrintfMisuseCheck.isLastArgumentThrowable(args)) {
                    this.reportIssue((Tree)mit, "Lambda should be used to differ string concatenation.");
                } else {
                    this.reportIssue((Tree)mit, "Format specifiers or lambda should be used instead of string concatenation.");
                }
            } else {
                this.reportIssue((Tree)mit, "Format specifiers should be used instead of string concatenation.");
            }
        }
    }

    private static boolean isIncorrectConcatenation(ExpressionTree formatStringTree) {
        return formatStringTree.is(new Tree.Kind[]{Tree.Kind.PLUS}) && !formatStringTree.asConstant().isPresent();
    }
}

