/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringEscapeUtils;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S4248")
public class RegexPatternsNeedlesslyCheck
extends AbstractMethodDetection {
    private static final String STRING = "java.lang.String";
    private static final String PATTERN = "java.util.regex.Pattern";
    private static final MethodMatcher SPLIT_MATCHER = MethodMatcher.create().typeDefinition("java.lang.String").name("split").withAnyParameters();

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return Arrays.asList(MethodMatcher.create().typeDefinition(PATTERN).name("compile").addParameter(STRING), MethodMatcher.create().typeDefinition(STRING).name("matches").withAnyParameters(), SPLIT_MATCHER, MethodMatcher.create().typeDefinition(STRING).name("replaceAll").withAnyParameters(), MethodMatcher.create().typeDefinition(STRING).name("replaceFirst").withAnyParameters());
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        Optional constantValue;
        ExpressionTree firstArgument = ExpressionUtils.skipParentheses((ExpressionTree)((ExpressionTree)mit.arguments().get(0)));
        if (SPLIT_MATCHER.matches(mit) && (constantValue = firstArgument.asConstant(String.class)).filter(RegexPatternsNeedlesslyCheck::exceptionSplitMethod).isPresent()) {
            return;
        }
        if (!RegexPatternsNeedlesslyCheck.storedInStaticFinal(mit) && (firstArgument.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL}) || RegexPatternsNeedlesslyCheck.isConstant((Tree)firstArgument))) {
            this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)mit), (Tree)mit.arguments(), "Refactor this code to use a \"static final\" Pattern.");
        }
    }

    private static boolean storedInStaticFinal(MethodInvocationTree mit) {
        Tree tree = mit.parent();
        while (!tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE, Tree.Kind.ASSIGNMENT, Tree.Kind.COMPILATION_UNIT})) {
            tree = tree.parent();
        }
        return RegexPatternsNeedlesslyCheck.isConstant(tree);
    }

    private static boolean isConstant(Tree tree) {
        Symbol symbol = null;
        switch (tree.kind()) {
            case IDENTIFIER: {
                symbol = ((IdentifierTree)tree).symbol();
                break;
            }
            case MEMBER_SELECT: {
                symbol = ((MemberSelectExpressionTree)tree).identifier().symbol();
                break;
            }
            case VARIABLE: {
                symbol = ((VariableTree)tree).symbol();
                break;
            }
            case ASSIGNMENT: {
                return RegexPatternsNeedlesslyCheck.isConstant((Tree)((AssignmentExpressionTree)tree).variable());
            }
        }
        return symbol != null && symbol.isFinal() && symbol.isStatic();
    }

    private static boolean exceptionSplitMethod(String argValue) {
        char ch;
        String regex = StringEscapeUtils.unescapeJava((String)argValue);
        return (regex.length() == 1 && ".$|()[{^?*+\\".indexOf(ch = regex.charAt(0)) == -1 || regex.length() == 2 && regex.charAt(0) == '\\' && ((ch = regex.charAt(1)) - 48 | 57 - ch) < 0 && (ch - 97 | 122 - ch) < 0 && (ch - 65 | 90 - ch) < 0) && (ch < '\ud800' || ch > '\udfff');
    }
}

