/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.JavaVersionAwareVisitor;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.MethodMatcherCollection;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1609")
public class SAMAnnotatedCheck
extends IssuableSubscriptionVisitor
implements JavaVersionAwareVisitor {
    private static final MethodMatcherCollection OBJECT_METHODS = MethodMatcherCollection.create((MethodMatcher[])new MethodMatcher[]{SAMAnnotatedCheck.methodMatcherWithName("equals", "java.lang.Object"), SAMAnnotatedCheck.methodMatcherWithName("getClass", new String[0]), SAMAnnotatedCheck.methodMatcherWithName("hashcode", new String[0]), SAMAnnotatedCheck.methodMatcherWithName("notify", new String[0]), SAMAnnotatedCheck.methodMatcherWithName("notifyAll", new String[0]), SAMAnnotatedCheck.methodMatcherWithName("toString", new String[0]), SAMAnnotatedCheck.methodMatcherWithName("wait", new String[0]), SAMAnnotatedCheck.methodMatcherWithName("wait", "long"), SAMAnnotatedCheck.methodMatcherWithName("wait", "long", "int")});

    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava8Compatible();
    }

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.INTERFACE);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        ClassTree classTree = (ClassTree)tree;
        if (SAMAnnotatedCheck.hasOneAbstractMethod(classTree.symbol()) && !SAMAnnotatedCheck.isAnnotated(classTree)) {
            IdentifierTree simpleName = classTree.simpleName();
            this.reportIssue((Tree)simpleName, "Annotate the \"" + simpleName.name() + "\" interface with the @FunctionalInterface annotation" + this.context.getJavaVersion().java8CompatibilityMessage());
        }
    }

    private static boolean isAnnotated(ClassTree tree) {
        return tree.symbol().metadata().isAnnotatedWith("java.lang.FunctionalInterface");
    }

    private static boolean hasOneAbstractMethod(Symbol.TypeSymbol symbol) {
        return SAMAnnotatedCheck.numberOfAbstractMethod((Symbol)symbol) == 1L && SAMAnnotatedCheck.noAbstractMethodInParentInterfaces(symbol.interfaces());
    }

    private static boolean noAbstractMethodInParentInterfaces(List<Type> interfaces) {
        return interfaces.stream().map(Type::symbol).noneMatch(symbol -> SAMAnnotatedCheck.numberOfAbstractMethod((Symbol)symbol) > 0L || !SAMAnnotatedCheck.noAbstractMethodInParentInterfaces(symbol.interfaces()));
    }

    private static long numberOfAbstractMethod(Symbol symbol) {
        if (symbol.isUnknown()) {
            return Integer.MAX_VALUE;
        }
        Symbol.TypeSymbol interfaceSymbol = (Symbol.TypeSymbol)symbol;
        return interfaceSymbol.memberSymbols().stream().filter(Symbol::isMethodSymbol).filter(member -> {
            Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)member;
            return SAMAnnotatedCheck.isNotObjectMethod(methodSymbol) && methodSymbol.isAbstract();
        }).count();
    }

    private static boolean isNotObjectMethod(Symbol.MethodSymbol method) {
        MethodTree declaration = method.declaration();
        return declaration == null || !OBJECT_METHODS.anyMatch(declaration);
    }

    private static MethodMatcher methodMatcherWithName(String name, String ... parameters) {
        return MethodMatcher.create().typeDefinition(TypeCriteria.anyType()).name(name).parameters(parameters);
    }
}

