/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2121")
public class SillyStringOperationsCheck
extends AbstractMethodDetection {
    private static final String CHAR_SEQUENCE = "java.lang.CharSequence";
    private static final String STRING = "java.lang.String";
    private static final MethodMatcher STRING_LENGTH = MethodMatcher.create().typeDefinition("java.lang.String").name("length").withoutParameter();

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return Arrays.asList(MethodMatcher.create().typeDefinition(STRING).name("contains").addParameter(TypeCriteria.subtypeOf((String)CHAR_SEQUENCE)), MethodMatcher.create().typeDefinition(STRING).name("compareTo").addParameter(TypeCriteria.is((String)STRING)), MethodMatcher.create().typeDefinition(STRING).name("compareToIgnoreCase").addParameter(TypeCriteria.is((String)STRING)), MethodMatcher.create().typeDefinition(STRING).name("endsWith").addParameter(TypeCriteria.is((String)STRING)), MethodMatcher.create().typeDefinition(STRING).name("indexOf").addParameter(TypeCriteria.is((String)STRING)), MethodMatcher.create().typeDefinition(STRING).name("indexOf").addParameter(TypeCriteria.is((String)STRING)).addParameter("int"), MethodMatcher.create().typeDefinition(STRING).name("lastIndexOf").addParameter(TypeCriteria.is((String)STRING)), MethodMatcher.create().typeDefinition(STRING).name("lastIndexOf").addParameter(TypeCriteria.is((String)STRING)).addParameter("int"), MethodMatcher.create().typeDefinition(STRING).name("matches").addParameter(TypeCriteria.is((String)STRING)), MethodMatcher.create().typeDefinition(STRING).name("replaceFirst").addParameter(TypeCriteria.is((String)STRING)).addParameter(TypeCriteria.is((String)STRING)), MethodMatcher.create().typeDefinition(STRING).name("split").addParameter(TypeCriteria.is((String)STRING)), MethodMatcher.create().typeDefinition(STRING).name("split").addParameter(TypeCriteria.is((String)STRING)).addParameter("int"), MethodMatcher.create().typeDefinition(STRING).name("startsWith").addParameter(TypeCriteria.is((String)STRING)), MethodMatcher.create().typeDefinition(STRING).name("startsWith").addParameter(TypeCriteria.is((String)STRING)).addParameter("int"), MethodMatcher.create().typeDefinition(STRING).name("substring").addParameter("int"), MethodMatcher.create().typeDefinition(STRING).name("substring").addParameter("int").addParameter("int"));
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree tree) {
        if (tree.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            boolean issue;
            String method;
            ExpressionTree str = ((MemberSelectExpressionTree)tree.methodSelect()).expression();
            Arguments args = tree.arguments();
            switch (method = tree.symbol().name()) {
                case "contains": 
                case "compareTo": 
                case "compareToIgnoreCase": 
                case "endsWith": 
                case "indexOf": 
                case "lastIndexOf": 
                case "matches": 
                case "split": 
                case "startsWith": {
                    issue = SillyStringOperationsCheck.checkStartsWith(str, args);
                    break;
                }
                case "replaceFirst": {
                    issue = SillyStringOperationsCheck.checkReplaceFirst(str, args);
                    break;
                }
                case "substring": {
                    issue = SillyStringOperationsCheck.checkSubstring(str, args);
                    break;
                }
                default: {
                    issue = false;
                }
            }
            if (issue) {
                this.reportIssue((Tree)tree, String.format("Remove this \"%s\" call; it has predictable results.", method));
            }
        }
    }

    private static boolean checkStartsWith(ExpressionTree str, Arguments args) {
        return SillyStringOperationsCheck.isSameString(str, (ExpressionTree)args.get(0));
    }

    private static boolean checkReplaceFirst(ExpressionTree str, Arguments args) {
        return SillyStringOperationsCheck.isSameString(str, (ExpressionTree)args.get(0)) || SillyStringOperationsCheck.isSameString((ExpressionTree)args.get(0), (ExpressionTree)args.get(1));
    }

    private static boolean checkSubstring(ExpressionTree str, Arguments args) {
        if (args.size() == 1) {
            return SillyStringOperationsCheck.isZero((ExpressionTree)args.get(0)) || SillyStringOperationsCheck.isStringLength(str, (ExpressionTree)args.get(0));
        }
        return SillyStringOperationsCheck.isStringLength(str, (ExpressionTree)args.get(0)) || SillyStringOperationsCheck.isZero((ExpressionTree)args.get(0)) && SillyStringOperationsCheck.isStringLength(str, (ExpressionTree)args.get(1));
    }

    private static boolean isSameString(ExpressionTree str, ExpressionTree tree) {
        return SillyStringOperationsCheck.isSameSymbol(str, tree) || SillyStringOperationsCheck.isSameStringLiteral(str, tree);
    }

    private static boolean isSameSymbol(ExpressionTree tree, ExpressionTree other) {
        Symbol s = SillyStringOperationsCheck.symbol(tree);
        return s != null && s.equals(SillyStringOperationsCheck.symbol(other));
    }

    private static boolean isSameStringLiteral(ExpressionTree str, ExpressionTree tree) {
        String s = SillyStringOperationsCheck.string(str);
        return s != null && s.equals(SillyStringOperationsCheck.string(tree));
    }

    private static boolean isZero(ExpressionTree tree) {
        return tree.asConstant(Integer.class).filter(n -> n == 0).isPresent();
    }

    private static boolean isStringLength(ExpressionTree str, ExpressionTree tree) {
        MethodInvocationTree invocation;
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && STRING_LENGTH.matches(invocation = (MethodInvocationTree)tree) && invocation.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            return SillyStringOperationsCheck.isSameSymbol(str, ((MemberSelectExpressionTree)invocation.methodSelect()).expression());
        }
        return false;
    }

    @CheckForNull
    private static Symbol symbol(ExpressionTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return ((IdentifierTree)tree).symbol();
        }
        return null;
    }

    @CheckForNull
    private static String string(ExpressionTree tree) {
        return tree.asConstant(String.class).orElse(null);
    }
}

