/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S2134")
public class ThreadOverridesRunCheck
extends IssuableSubscriptionVisitor {
    private static final String JAVA_LANG_THREAD = "java.lang.Thread";
    private static final MethodMatcher RUN = MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"java.lang.Thread")).name("run").withoutParameter();

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        Symbol.TypeSymbol classSymbol = classTree.symbol();
        if (classSymbol != null && ThreadOverridesRunCheck.isDirectSubtypeOfThread(classSymbol) && !ThreadOverridesRunCheck.overridesRunMethod(classSymbol) && !ThreadOverridesRunCheck.hasConstructorCallingSuperWithRunnable(classTree)) {
            IdentifierTree report = classTree.simpleName();
            Tree parent = classTree.parent();
            if (parent.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS})) {
                NewClassTree newClassTree = (NewClassTree)parent;
                if (ThreadOverridesRunCheck.hasRunnableArgument(newClassTree.arguments())) {
                    return;
                }
                report = newClassTree.identifier();
            }
            this.reportIssue((Tree)report, "Don't extend \"Thread\", since the \"run\" method is not overridden.");
        }
    }

    private static boolean isDirectSubtypeOfThread(Symbol.TypeSymbol classSymbol) {
        Type superClass = classSymbol.superClass();
        return superClass != null && superClass.is(JAVA_LANG_THREAD);
    }

    private static boolean overridesRunMethod(Symbol.TypeSymbol classSymbol) {
        return classSymbol.lookupSymbols("run").stream().anyMatch(arg_0 -> ((MethodMatcher)RUN).matches(arg_0));
    }

    private static boolean hasConstructorCallingSuperWithRunnable(ClassTree classTree) {
        return classTree.members().stream().filter(member -> member.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR})).map(MethodTree.class::cast).anyMatch(ThreadOverridesRunCheck::hasCallToSuperWithRunnable);
    }

    private static boolean hasRunnableArgument(Arguments args) {
        return args.stream().anyMatch(ThreadOverridesRunCheck::isRunnable);
    }

    private static boolean isRunnable(ExpressionTree arg) {
        return arg.symbolType().isSubtypeOf("java.lang.Runnable");
    }

    private static boolean hasCallToSuperWithRunnable(MethodTree constructor) {
        SuperRunnableVisitor visitor = new SuperRunnableVisitor();
        constructor.accept((TreeVisitor)visitor);
        return visitor.callSuperWithRunnable;
    }

    private static class SuperRunnableVisitor
    extends BaseTreeVisitor {
        private boolean callSuperWithRunnable = false;
        private static final MethodMatcher SUPER_THREAD = MethodMatcher.create().typeDefinition("java.lang.Thread").name("<init>").withAnyParameters();

        private SuperRunnableVisitor() {
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            if (SUPER_THREAD.matches(tree) && ThreadOverridesRunCheck.hasRunnableArgument(tree.arguments())) {
                this.callSuperWithRunnable = true;
                return;
            }
            super.visitMethodInvocation(tree);
        }

        public void visitClass(ClassTree tree) {
        }
    }
}

