/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ValueBasedUtils;
import org.sonar.java.checks.serialization.SerializableContract;
import org.sonar.java.model.JUtils;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S3437")
public class ValueBasedObjectsShouldNotBeSerializedCheck
extends IssuableSubscriptionVisitor {
    private static final String MESSAGE = "Make this value-based field transient so it is not included in the serialization of this class.";

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.CLASS, Tree.Kind.ENUM, Tree.Kind.ANNOTATION_TYPE);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (classTree.is(new Tree.Kind[]{Tree.Kind.ANNOTATION_TYPE})) {
            classTree.members().stream().filter(member -> member.is(new Tree.Kind[]{Tree.Kind.METHOD})).map(member -> (MethodTree)member).filter(ValueBasedObjectsShouldNotBeSerializedCheck::isReturnTypeValueBased).forEach(meth -> this.reportIssue((Tree)meth.simpleName(), MESSAGE));
        } else if (ValueBasedObjectsShouldNotBeSerializedCheck.isSerializable(classTree) && !SerializableContract.hasSpecialHandlingSerializationMethods(classTree)) {
            classTree.members().stream().filter(ValueBasedObjectsShouldNotBeSerializedCheck::isVariable).map(member -> (VariableTree)member).filter(var -> !ValueBasedObjectsShouldNotBeSerializedCheck.isStatic(var)).filter(var -> !ValueBasedObjectsShouldNotBeSerializedCheck.isTransient(var)).filter(ValueBasedObjectsShouldNotBeSerializedCheck::isVarSerializableAndValueBased).forEach(var -> this.reportIssue((Tree)var.simpleName(), MESSAGE));
        }
    }

    private static boolean isVarSerializableAndValueBased(VariableTree var) {
        return var.type() != null && ValueBasedObjectsShouldNotBeSerializedCheck.isSerializableAndValueBased(var.type().symbolType());
    }

    private static boolean isReturnTypeValueBased(MethodTree method) {
        return ValueBasedUtils.isValueBased(method.returnType().symbolType());
    }

    private static boolean isSerializableAndValueBased(Type type) {
        if (JUtils.isParametrized((Type)type)) {
            return ValueBasedObjectsShouldNotBeSerializedCheck.isSubtypeOfCollectionApi(type) && JUtils.typeArguments((Type)type).stream().anyMatch(ValueBasedObjectsShouldNotBeSerializedCheck::isSerializableAndValueBased);
        }
        return ValueBasedUtils.isValueBased(type);
    }

    private static boolean isVariable(Tree member) {
        return member.is(new Tree.Kind[]{Tree.Kind.VARIABLE, Tree.Kind.ENUM_CONSTANT});
    }

    private static boolean isSerializable(ClassTree classTree) {
        return classTree.symbol().type().isSubtypeOf("java.io.Serializable");
    }

    private static boolean isStatic(VariableTree variable) {
        return ModifiersUtils.hasModifier((ModifiersTree)variable.modifiers(), (Modifier)Modifier.STATIC);
    }

    private static boolean isTransient(VariableTree variable) {
        return ModifiersUtils.hasModifier((ModifiersTree)variable.modifiers(), (Modifier)Modifier.TRANSIENT);
    }

    private static boolean isSubtypeOfCollectionApi(Type type) {
        return type.isSubtypeOf("java.util.Collection") || type.isSubtypeOf("java.util.Map");
    }
}

