/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.NameCriteria;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2274")
public class WaitInWhileLoopCheck
extends AbstractMethodDetection {
    private Deque<Boolean> inWhileLoop = new LinkedList<Boolean>();

    public void setContext(JavaFileScannerContext context) {
        this.inWhileLoop.push(false);
        super.setContext(context);
    }

    public void leaveFile(JavaFileScannerContext context) {
        this.inWhileLoop.clear();
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD_INVOCATION, Tree.Kind.WHILE_STATEMENT, Tree.Kind.DO_STATEMENT, Tree.Kind.FOR_STATEMENT);
    }

    @Override
    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            super.visitNode(tree);
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.FOR_STATEMENT})) {
            ForStatementTree fst = (ForStatementTree)tree;
            this.inWhileLoop.push(fst.initializer().isEmpty() && fst.condition() == null && fst.update().isEmpty());
        } else {
            this.inWhileLoop.push(true);
        }
    }

    public void leaveNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.WHILE_STATEMENT, Tree.Kind.DO_STATEMENT, Tree.Kind.FOR_STATEMENT})) {
            this.inWhileLoop.pop();
        }
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        if (!Boolean.TRUE.equals(this.inWhileLoop.peek())) {
            IdentifierTree identifierTree = ExpressionUtils.methodName((MethodInvocationTree)mit);
            this.reportIssue((Tree)identifierTree, "Remove this call to \"" + identifierTree.name() + "\" or move it into a \"while\" loop.");
        }
    }

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return Arrays.asList(MethodMatcher.create().name("wait").withoutParameter(), MethodMatcher.create().name("wait").addParameter("long"), MethodMatcher.create().name("wait").addParameter("long").addParameter("int"), MethodMatcher.create().typeDefinition("java.util.concurrent.locks.Condition").name(NameCriteria.startsWith((String)"await")).withAnyParameters());
    }
}

