/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.helpers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.java.checks.helpers.ReassignmentFinder;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.JUtils;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

public class ExpressionsHelper {
    private ExpressionsHelper() {
    }

    public static String concatenate(@Nullable ExpressionTree tree) {
        if (tree == null) {
            return "";
        }
        LinkedList<String> pieces = new LinkedList<String>();
        ExpressionTree expr = tree;
        while (expr.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            MemberSelectExpressionTree mse = (MemberSelectExpressionTree)expr;
            pieces.push(mse.identifier().name());
            pieces.push(".");
            expr = mse.expression();
        }
        if (expr.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            IdentifierTree idt = (IdentifierTree)expr;
            pieces.push(idt.name());
        }
        StringBuilder sb = new StringBuilder();
        for (String piece : pieces) {
            sb.append(piece);
        }
        return sb.toString();
    }

    public static Tree reportOnClassTree(ClassTree classTree) {
        IdentifierTree reportTree = classTree.simpleName();
        if (reportTree == null) {
            reportTree = ((NewClassTree)classTree.parent()).identifier();
        }
        return reportTree;
    }

    public static ValueResolution<String> getConstantValueAsString(ExpressionTree expression) {
        return ExpressionsHelper.valueResolution(expression, expr -> expr.asConstant(String.class), new ValueResolution());
    }

    public static ValueResolution<Boolean> getConstantValueAsBoolean(ExpressionTree expression) {
        return ExpressionsHelper.valueResolution(expression, expr -> expr.asConstant(Boolean.class), new ValueResolution());
    }

    private static <T> ValueResolution<T> valueResolution(ExpressionTree expression, Function<ExpressionTree, Optional<T>> resolver, ValueResolution<T> valueResolution) {
        Symbol symbol;
        ExpressionTree singleWriteUsage;
        Optional<T> value = resolver.apply(expression);
        if (!value.isPresent() && expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && (singleWriteUsage = ExpressionsHelper.getSingleWriteUsage(symbol = ((IdentifierTree)expression).symbol())) != null && !((ValueResolution)valueResolution).evaluatedSymbols.contains(symbol)) {
            ((ValueResolution)valueResolution).addLocation(singleWriteUsage, symbol);
            return ExpressionsHelper.valueResolution(singleWriteUsage, resolver, valueResolution);
        }
        ((ValueResolution)valueResolution).value = value.orElse(null);
        return valueResolution;
    }

    @CheckForNull
    private static ExpressionTree getSingleWriteUsage(Symbol symbol) {
        ExpressionTree initializerOrExpression = ReassignmentFinder.getInitializerOrExpression(symbol.declaration());
        List<AssignmentExpressionTree> reassignments = ReassignmentFinder.getReassignments(symbol.owner().declaration(), symbol.usages());
        ExpressionTree singleWriteUsage = null;
        if (initializerOrExpression == null && reassignments.size() == 1) {
            singleWriteUsage = reassignments.get(0).expression();
        }
        if (initializerOrExpression != null && reassignments.isEmpty()) {
            singleWriteUsage = initializerOrExpression;
        }
        if (singleWriteUsage != null && ExpressionsHelper.isStrictAssignmentOrDeclaration(singleWriteUsage)) {
            return singleWriteUsage;
        }
        return null;
    }

    private static boolean isStrictAssignmentOrDeclaration(ExpressionTree expression) {
        if (expression.parent() instanceof AssignmentExpressionTree) {
            return expression.parent().is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT});
        }
        return true;
    }

    public static boolean isNotSerializable(ExpressionTree expression) {
        return ExpressionsHelper.isNonSerializable(expression.symbolType()) || ExpressionsHelper.isAssignedToNonSerializable(expression);
    }

    private static boolean isNonSerializable(Type type) {
        if (type.isArray()) {
            return ExpressionsHelper.isNonSerializable(((Type.ArrayType)type).elementType());
        }
        if (JUtils.typeArguments((Type)type).stream().anyMatch(ExpressionsHelper::isNonSerializable)) {
            return true;
        }
        if (type.isPrimitive() || type.is("java.lang.Object") || type.isSubtypeOf("java.io.Serializable")) {
            return false;
        }
        if (type.isSubtypeOf("java.lang.Iterable") || type.isSubtypeOf("java.util.Map") || type.isSubtypeOf("java.util.Enumeration")) {
            return false;
        }
        Type erasedType = type.erasure();
        return erasedType.equals(type) || ExpressionsHelper.isNonSerializable(erasedType);
    }

    private static boolean isAssignedToNonSerializable(ExpressionTree expression) {
        return ExpressionUtils.extractIdentifierSymbol((ExpressionTree)expression).filter(symbol -> ExpressionsHelper.initializedAndAssignedExpressionStream(symbol).anyMatch(ExpressionsHelper::isNotSerializable)).isPresent();
    }

    public static Stream<ExpressionTree> initializedAndAssignedExpressionStream(Symbol symbol) {
        Tree declaration = symbol.declaration();
        if (declaration == null) {
            return Stream.empty();
        }
        Stream<ExpressionTree> assignedExpressionStream = ReassignmentFinder.getReassignments(declaration, symbol.usages()).stream().map(AssignmentExpressionTree::expression);
        ExpressionTree initializer = ReassignmentFinder.getInitializerOrExpression(declaration);
        if (initializer == null) {
            return assignedExpressionStream;
        }
        return Stream.concat(Stream.of(initializer), assignedExpressionStream);
    }

    public static class ValueResolution<T> {
        private T value;
        private List<JavaFileScannerContext.Location> valuePath = new ArrayList<JavaFileScannerContext.Location>();
        private Set<Symbol> evaluatedSymbols = new HashSet<Symbol>();

        private void addLocation(ExpressionTree expressionTree, Symbol evaluatedSymbol) {
            this.evaluatedSymbols.add(evaluatedSymbol);
            this.valuePath.add(new JavaFileScannerContext.Location("", (Tree)expressionTree));
        }

        @CheckForNull
        public T value() {
            return this.value;
        }

        public List<JavaFileScannerContext.Location> valuePath() {
            return this.valuePath;
        }
    }
}

