/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S4426")
public class CryptographicKeySizeCheck
extends AbstractMethodDetection {
    private static final String KEY_PAIR_GENERATOR = "java.security.KeyPairGenerator";
    private static final String KEY_GENERATOR = "javax.crypto.KeyGenerator";
    private static final String EC_GEN_PARAMETER_SPEC = "java.security.spec.ECGenParameterSpec";
    private static final String GET_INSTANCE_METHOD = "getInstance";
    private static final String STRING = "java.lang.String";
    private static final int EC_MIN_KEY = 224;
    private static final Pattern EC_KEY_PATTERN = Pattern.compile("^(secp|prime|sect|c2tnb)(\\d+)");
    private static final Map<String, Integer> ALGORITHM_KEY_SIZE_MAP = ImmutableMap.of((Object)"RSA", (Object)2048, (Object)"DH", (Object)2048, (Object)"DIFFIEHELLMAN", (Object)2048, (Object)"DSA", (Object)2048, (Object)"AES", (Object)128);
    private static final MethodMatcher KEY_GEN_INIT = MethodMatcher.create().typeDefinition("javax.crypto.KeyGenerator").name("init").addParameter("int");
    private static final MethodMatcher KEY_PAIR_GEN_INITIALIZE = MethodMatcher.create().typeDefinition("java.security.KeyPairGenerator").name("initialize").addParameter("int");
    private static final MethodMatcher KEY_PAIR_GEN_INITIALIZE_WITH_SOURCE = KEY_PAIR_GEN_INITIALIZE.copy().addParameter("java.security.SecureRandom");

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return Arrays.asList(MethodMatcher.create().typeDefinition(KEY_GENERATOR).name(GET_INSTANCE_METHOD).addParameter(STRING), MethodMatcher.create().typeDefinition(KEY_PAIR_GENERATOR).name(GET_INSTANCE_METHOD).addParameter(STRING), MethodMatcher.create().typeDefinition(EC_GEN_PARAMETER_SPEC).name("<init>").addParameter(STRING));
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        MethodTree methodTree = ExpressionUtils.getEnclosingMethod((ExpressionTree)mit);
        String getInstanceArg = ExpressionsHelper.getConstantValueAsString((ExpressionTree)mit.arguments().get(0)).value();
        if (methodTree != null && getInstanceArg != null) {
            Optional assignedSymbol = ExpressionUtils.getAssignedSymbol((ExpressionTree)mit);
            MethodVisitor methodVisitor = new MethodVisitor(getInstanceArg, assignedSymbol.orElse(null));
            methodTree.accept((TreeVisitor)methodVisitor);
        }
    }

    @Override
    protected void onConstructorFound(NewClassTree newClassTree) {
        Matcher matcher;
        String firstArgument = ExpressionsHelper.getConstantValueAsString((ExpressionTree)newClassTree.arguments().get(0)).value();
        if (firstArgument != null && (matcher = EC_KEY_PATTERN.matcher(firstArgument)).find() && Integer.valueOf(matcher.group(2)) < 224) {
            this.reportIssue((Tree)newClassTree, "Use a key length of at least 224 bits for EC cipher algorithm.");
        }
    }

    private class MethodVisitor
    extends BaseTreeVisitor {
        private final String algorithm;
        private final Integer minKeySize;
        private final Symbol variable;

        public MethodVisitor(@Nullable String getInstanceArg, Symbol variable) {
            this.algorithm = getInstanceArg;
            this.minKeySize = (Integer)ALGORITHM_KEY_SIZE_MAP.get(this.algorithm.toUpperCase(Locale.ENGLISH));
            this.variable = variable;
        }

        public void visitMethodInvocation(MethodInvocationTree mit) {
            Integer keySize;
            if (this.minKeySize != null && (KEY_GEN_INIT.matches(mit) || KEY_PAIR_GEN_INITIALIZE.matches(mit) || KEY_PAIR_GEN_INITIALIZE_WITH_SOURCE.matches(mit)) && (keySize = LiteralUtils.intLiteralValue((ExpressionTree)((ExpressionTree)mit.arguments().get(0)))) != null && keySize < this.minKeySize && ExpressionUtils.isInvocationOnVariable((MethodInvocationTree)mit, (Symbol)this.variable, (boolean)false)) {
                CryptographicKeySizeCheck.this.reportIssue((Tree)mit, "Use a key length of at least " + this.minKeySize + " bits for " + this.algorithm + " cipher algorithm.");
            }
        }
    }
}

