/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S5679")
public class OpenSAML2AuthenticationBypassCheck
extends AbstractMethodDetection {
    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return Collections.singletonList(MethodMatcher.create().typeDefinition(type -> type.isSubtypeOf("org.opensaml.xml.parse.BasicParserPool") || type.isSubtypeOf("org.opensaml.xml.parse.StaticBasicParserPool")).name("setIgnoreComments").addParameter("boolean"));
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        ExpressionTree arg0 = (ExpressionTree)mit.arguments().get(0);
        arg0.asConstant(Boolean.class).filter(Boolean.FALSE::equals).ifPresent(value -> this.reportIssue((Tree)arg0, "Change \"setIgnoreComments\" to \"true\" or remove the call to \"setIgnoreComments\" to prevent the authentication bypass."));
    }
}

