/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.serialization;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;

public final class SerializableContract {
    public static final Set<String> SERIALIZABLE_CONTRACT_METHODS = ImmutableSet.of((Object)"writeObject", (Object)"readObject", (Object)"writeReplace", (Object)"readResolve", (Object)"readObjectNoData");
    public static final String SERIAL_VERSION_UID_FIELD = "serialVersionUID";

    private SerializableContract() {
    }

    public static boolean hasSpecialHandlingSerializationMethods(ClassTree classTree) {
        boolean hasWriteObject = false;
        boolean hasReadObject = false;
        String classFullyQualifiedName = classTree.symbol().type().fullyQualifiedName();
        for (Tree member : classTree.members()) {
            MethodTree methodTree;
            MethodMatcher writeObjectMatcher = SerializableContract.writeObjectMatcher(classFullyQualifiedName);
            MethodMatcher readObjectMatcher = SerializableContract.readObjectMatcher(classFullyQualifiedName);
            if (!member.is(new Tree.Kind[]{Tree.Kind.METHOD}) || !ModifiersUtils.hasModifier((ModifiersTree)(methodTree = (MethodTree)member).modifiers(), (Modifier)Modifier.PRIVATE)) continue;
            hasWriteObject |= writeObjectMatcher.matches(methodTree) && SerializableContract.methodThrows(methodTree, "java.io.IOException");
            hasReadObject |= readObjectMatcher.matches(methodTree) && SerializableContract.methodThrows(methodTree, "java.io.IOException", "java.lang.ClassNotFoundException");
        }
        return hasReadObject && hasWriteObject;
    }

    public static MethodMatcher readObjectMatcher(String classFullyQualifiedName) {
        return MethodMatcher.create().typeDefinition(classFullyQualifiedName).name("readObject").addParameter("java.io.ObjectInputStream");
    }

    public static MethodMatcher writeObjectMatcher(String classFullyQualifiedName) {
        return MethodMatcher.create().typeDefinition(classFullyQualifiedName).name("writeObject").addParameter("java.io.ObjectOutputStream");
    }

    private static boolean methodThrows(MethodTree methodTree, String ... throwClauseFullyQualifiedNames) {
        List thrownTypes = methodTree.symbol().thrownTypes();
        if (thrownTypes.isEmpty() || thrownTypes.size() != throwClauseFullyQualifiedNames.length) {
            return false;
        }
        for (Type thrownType : thrownTypes) {
            boolean match = false;
            for (String fullyQualifiedName : throwClauseFullyQualifiedNames) {
                match |= thrownType.is(fullyQualifiedName);
            }
            if (match) continue;
            return false;
        }
        return true;
    }
}

