/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.synchronization;

import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SynchronizedStatementTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S2168")
public class DoubleCheckedLockingCheck
extends IssuableSubscriptionVisitor {
    private Deque<IfFieldEqNull> ifFieldStack = new LinkedList<IfFieldEqNull>();
    private Deque<CriticalSection> synchronizedStmtStack = new LinkedList<CriticalSection>();
    private boolean methodIsSynchronized;

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.IF_STATEMENT, Tree.Kind.SYNCHRONIZED_STATEMENT, Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        DoubleCheckedLockingCheck.isIfFieldEqNull(tree).ifPresent(ifFieldEqNull -> {
            this.ifFieldStack.push((IfFieldEqNull)ifFieldEqNull);
            this.visitIfStatement(((IfFieldEqNull)ifFieldEqNull).ifTree);
        });
        if (tree.is(new Tree.Kind[]{Tree.Kind.SYNCHRONIZED_STATEMENT})) {
            CriticalSection criticalSection = new CriticalSection((SynchronizedStatementTree)tree, this.ifFieldStack.size());
            this.synchronizedStmtStack.push(criticalSection);
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
            this.methodIsSynchronized = ModifiersUtils.hasModifier((ModifiersTree)((MethodTree)tree).modifiers(), (Modifier)Modifier.SYNCHRONIZED);
        }
    }

    public void leaveNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        DoubleCheckedLockingCheck.isIfFieldEqNull(tree).ifPresent(cl -> this.ifFieldStack.pop());
        if (tree.is(new Tree.Kind[]{Tree.Kind.SYNCHRONIZED_STATEMENT})) {
            this.synchronizedStmtStack.pop();
        }
    }

    private static Optional<IfFieldEqNull> isIfFieldEqNull(Tree tree) {
        if (!tree.is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT})) {
            return Optional.empty();
        }
        IfStatementTree ifTree = (IfStatementTree)tree;
        if (!ifTree.condition().is(new Tree.Kind[]{Tree.Kind.EQUAL_TO})) {
            return Optional.empty();
        }
        BinaryExpressionTree eqRelation = (BinaryExpressionTree)ifTree.condition();
        if (eqRelation.rightOperand().is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL})) {
            return DoubleCheckedLockingCheck.isField(eqRelation.leftOperand()).map(f -> new IfFieldEqNull(ifTree, (Symbol)f));
        }
        if (eqRelation.leftOperand().is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL})) {
            return DoubleCheckedLockingCheck.isField(eqRelation.rightOperand()).map(f -> new IfFieldEqNull(ifTree, (Symbol)f));
        }
        return Optional.empty();
    }

    private void visitIfStatement(IfStatementTree ifTree) {
        if (this.insideCriticalSection()) {
            Optional<IfFieldEqNull> parentIf = this.sameFieldAlreadyOnStack(this.ifFieldStack.peek());
            parentIf.ifPresent(pIf -> this.ifSynchronizedIfPattern((IfFieldEqNull)pIf, ifTree));
        }
    }

    private void ifSynchronizedIfPattern(IfFieldEqNull parentIf, IfStatementTree nestedIf) {
        if (DoubleCheckedLockingCheck.thenStmtInitializeField(nestedIf.thenStatement(), parentIf.field) && !parentIf.field.isVolatile() && !this.methodIsSynchronized) {
            SyntaxToken synchronizedKeyword = this.synchronizedStmtStack.peek().synchronizedTree.synchronizedKeyword();
            this.reportIssue((Tree)synchronizedKeyword, "Remove this dangerous instance of double-checked locking.", DoubleCheckedLockingCheck.createFlow(parentIf.ifTree, nestedIf), null);
        }
    }

    private static List<JavaFileScannerContext.Location> createFlow(IfStatementTree parentIf, IfStatementTree nestedIf) {
        return Stream.of(parentIf.condition(), nestedIf.condition()).map(c -> new JavaFileScannerContext.Location("Double-checked locking", (Tree)c)).collect(Collectors.toList());
    }

    private boolean insideCriticalSection() {
        return !this.synchronizedStmtStack.isEmpty();
    }

    private Optional<IfFieldEqNull> sameFieldAlreadyOnStack(IfFieldEqNull nestedIf) {
        int aboveSynchronized = this.ifFieldStack.size() - this.synchronizedStmtStack.peek().ifStackDepth;
        return this.ifFieldStack.stream().skip(aboveSynchronized).filter(parentIf -> ((IfFieldEqNull)parentIf).field == nestedIf.field).findFirst();
    }

    private static Optional<Symbol> isField(ExpressionTree expressionTree) {
        return DoubleCheckedLockingCheck.symbolFromVariable(expressionTree).filter(s -> s.isVariableSymbol() && s.owner().isTypeSymbol());
    }

    private static Optional<Symbol> symbolFromVariable(ExpressionTree variable) {
        if (variable.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return Optional.of(((IdentifierTree)variable).symbol());
        }
        if (variable.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            return Optional.of(((MemberSelectExpressionTree)variable).identifier().symbol());
        }
        return Optional.empty();
    }

    private static boolean thenStmtInitializeField(StatementTree statementTree, Symbol field) {
        AssignmentVisitor visitor = new AssignmentVisitor(field);
        statementTree.accept((TreeVisitor)visitor);
        return visitor.assignmentToField;
    }

    private static class CriticalSection {
        SynchronizedStatementTree synchronizedTree;
        int ifStackDepth;

        public CriticalSection(SynchronizedStatementTree synchronizedTree, int ifStackDepth) {
            this.synchronizedTree = synchronizedTree;
            this.ifStackDepth = ifStackDepth;
        }
    }

    private static class IfFieldEqNull {
        private final IfStatementTree ifTree;
        private final Symbol field;

        private IfFieldEqNull(IfStatementTree ifTree, Symbol field) {
            this.ifTree = ifTree;
            this.field = field;
        }
    }

    private static class AssignmentVisitor
    extends BaseTreeVisitor {
        private boolean assignmentToField;
        private Symbol field;

        AssignmentVisitor(Symbol field) {
            this.field = field;
        }

        public void visitAssignmentExpression(AssignmentExpressionTree assignmentTree) {
            ExpressionTree variable = assignmentTree.variable();
            DoubleCheckedLockingCheck.symbolFromVariable(variable).filter(s -> s == this.field).ifPresent(s -> {
                this.assignmentToField = true;
            });
        }
    }
}

