/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.synchronization;

import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.SynchronizedStatementTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S3046")
public class TwoLocksWaitCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatcher WAIT_MATCHER = MethodMatcher.create().name("wait").withoutParameter();
    private Deque<Counter> synchronizedStack = new LinkedList<Counter>();

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD, Tree.Kind.CONSTRUCTOR);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD, Tree.Kind.CONSTRUCTOR})) {
            MethodTree methodTree = (MethodTree)tree;
            int initialCounter = ModifiersUtils.findModifier((ModifiersTree)methodTree.modifiers(), (Modifier)Modifier.SYNCHRONIZED).map(m -> 1).orElse(0);
            this.synchronizedStack.push(new Counter(initialCounter));
            this.findWaitInvocation(methodTree);
        }
    }

    public void leaveNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD, Tree.Kind.CONSTRUCTOR})) {
            this.synchronizedStack.pop();
        }
    }

    private void findWaitInvocation(MethodTree tree) {
        this.findMethodCall((Tree)tree, WAIT_MATCHER).ifPresent(wait -> this.reportIssue((Tree)wait, "Don't use \"wait()\" here; multiple locks are held.", TwoLocksWaitCheck.flowFromTree((Tree)tree), null));
    }

    private Optional<MethodInvocationTree> findMethodCall(Tree tree, MethodMatcher methodMatcher) {
        MethodInvocationVisitor visitor = new MethodInvocationVisitor(methodMatcher);
        tree.accept((TreeVisitor)visitor);
        return visitor.matchedMethods().findAny();
    }

    private static List<JavaFileScannerContext.Location> flowFromTree(Tree tree) {
        SynchronizedKeywordVisitor synchronizedKeywordVisitor = new SynchronizedKeywordVisitor();
        tree.accept((TreeVisitor)synchronizedKeywordVisitor);
        return synchronizedKeywordVisitor.stream().map(t -> new JavaFileScannerContext.Location("locking", (Tree)t)).collect(Collectors.toList());
    }

    private static class Counter {
        int value;

        private Counter(int initialValue) {
            this.value = initialValue;
        }

        void increment() {
            ++this.value;
        }

        void decrement() {
            --this.value;
        }
    }

    private static class SynchronizedKeywordVisitor
    extends BaseTreeVisitor {
        private Stream.Builder<SyntaxToken> synchronizedKeywords = Stream.builder();

        private SynchronizedKeywordVisitor() {
        }

        public void visitSynchronizedStatement(SynchronizedStatementTree tree) {
            this.synchronizedKeywords.add(tree.synchronizedKeyword());
            super.visitSynchronizedStatement(tree);
        }

        public void visitMethod(MethodTree tree) {
            ModifiersUtils.findModifier((ModifiersTree)tree.modifiers(), (Modifier)Modifier.SYNCHRONIZED).ifPresent(s -> this.synchronizedKeywords.add(s.keyword()));
            super.visitMethod(tree);
        }

        Stream<SyntaxToken> stream() {
            return this.synchronizedKeywords.build();
        }
    }

    private class MethodInvocationVisitor
    extends BaseTreeVisitor {
        private final MethodMatcher methodMatcher;
        private Stream.Builder<MethodInvocationTree> matchedMethods = Stream.builder();

        private MethodInvocationVisitor(MethodMatcher methodMatcher) {
            this.methodMatcher = methodMatcher;
        }

        public void visitSynchronizedStatement(SynchronizedStatementTree tree) {
            ((Counter)TwoLocksWaitCheck.this.synchronizedStack.peek()).increment();
            super.visitSynchronizedStatement(tree);
            ((Counter)TwoLocksWaitCheck.this.synchronizedStack.peek()).decrement();
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            if (this.methodMatcher.matches(tree) && ((Counter)((TwoLocksWaitCheck)TwoLocksWaitCheck.this).synchronizedStack.peek()).value >= 2) {
                this.matchedMethods.add(tree);
            }
            super.visitMethodInvocation(tree);
        }

        public void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree) {
        }

        public void visitClass(ClassTree tree) {
        }

        private Stream<MethodInvocationTree> matchedMethods() {
            return this.matchedMethods.build();
        }
    }
}

