/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.xml.struts;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.xml.xpath.XPathExpression;
import org.sonar.check.Rule;
import org.sonarsource.analyzer.commons.xml.XmlFile;
import org.sonarsource.analyzer.commons.xml.checks.SimpleXPathBasedCheck;
import org.sonarsource.analyzer.commons.xml.checks.SonarXmlCheck;
import org.w3c.dom.Node;

@Rule(key="S3374")
public class FormNameDuplicationCheck
extends SimpleXPathBasedCheck {
    private XPathExpression formsetsExpression = this.getXPathExpression("form-validation/formset");
    private XPathExpression formsExpression = this.getXPathExpression("form");

    public void scanFile(XmlFile xmlFile) {
        this.evaluateAsList(this.formsetsExpression, xmlFile.getNamespaceUnawareDocument()).forEach(this::checkIfDuplicate);
    }

    private void checkIfDuplicate(Node formSet) {
        HashMap formsByName = new HashMap();
        this.evaluateAsList(this.formsExpression, formSet).forEach(form -> {
            String name = FormNameDuplicationCheck.getNameAttribute(form);
            Node original = (Node)formsByName.get(name);
            if (original == null) {
                formsByName.put(name, form);
            } else {
                this.reportIssue((Node)form, original);
            }
        });
    }

    private void reportIssue(Node duplicate, Node original) {
        String msg = "Rename this form; line " + XmlFile.nodeLocation((Node)original).getStartLine() + " holds another form declaration with the same name.";
        List<SonarXmlCheck.Secondary> secondaries = Collections.singletonList(new SonarXmlCheck.Secondary(original, "original"));
        this.reportIssue(XmlFile.nodeLocation((Node)duplicate), msg, secondaries);
    }

    @CheckForNull
    private static String getNameAttribute(Node form) {
        Node name = XmlFile.nodeAttribute((Node)form, (String)"name");
        if (name != null) {
            return name.getNodeValue();
        }
        return null;
    }
}

