/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.samples.java.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="NoIfStatementInTests")
public class NoIfStatementInTestsRule
extends IssuableSubscriptionVisitor {
    private final BaseTreeVisitor ifStatementVisitor = new IfStatementVisitor();

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTree method = (MethodTree)tree;
        if (!NoIfStatementInTestsRule.isJunit4TestMethod(method)) {
            return;
        }
        BlockTree block = method.block();
        if (block == null) {
            return;
        }
        block.accept((TreeVisitor)this.ifStatementVisitor);
    }

    private static boolean isJunit4TestMethod(MethodTree method) {
        return method.symbol().metadata().isAnnotatedWith("org.junit.Test");
    }

    private class IfStatementVisitor
    extends BaseTreeVisitor {
        private IfStatementVisitor() {
        }

        public void visitIfStatement(IfStatementTree tree) {
            NoIfStatementInTestsRule.this.reportIssue((Tree)tree.ifKeyword(), "Remove this 'if' statement from this test.");
            super.visitIfStatement(tree);
        }

        public void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree) {
        }

        public void visitClass(ClassTree tree) {
        }
    }
}

