/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.samples.java.utils;

import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.samples.java.utils.StringUtils;

public class PrinterVisitor
extends BaseTreeVisitor {
    private static final int INDENT_SPACES = 2;
    private final StringBuilder sb = new StringBuilder();
    private int indentLevel = 0;

    public static void print(Tree tree, Consumer<String> output) {
        PrinterVisitor pv = new PrinterVisitor();
        pv.scan(tree);
        output.accept(pv.sb.toString());
    }

    private StringBuilder indent() {
        return this.sb.append(StringUtils.spaces(2 * this.indentLevel));
    }

    protected void scan(List<? extends Tree> trees) {
        if (!trees.isEmpty()) {
            this.sb.deleteCharAt(this.sb.length() - 1);
            this.sb.append(" : [\n");
            super.scan(trees);
            this.indent().append("]\n");
        }
    }

    protected void scan(@Nullable Tree tree) {
        Class<?>[] interfaces;
        if (tree != null && (interfaces = tree.getClass().getInterfaces()).length > 0) {
            this.indent().append(interfaces[0].getSimpleName()).append("\n");
        }
        ++this.indentLevel;
        super.scan(tree);
        --this.indentLevel;
    }
}

