/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.samples.java.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;

@Rule(key="AvoidAnnotation")
public class AvoidAnnotationRule
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final String DEFAULT_VALUE = "Inject";
    private JavaFileScannerContext context;
    @RuleProperty(defaultValue="Inject", description="Name of the annotation to avoid, without the prefix @, for instance 'Override'")
    protected String name;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitMethod(MethodTree tree) {
        List annotations = tree.modifiers().annotations();
        for (AnnotationTree annotationTree : annotations) {
            IdentifierTree identifier;
            TypeTree annotationType = annotationTree.annotationType();
            if (!annotationType.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) || !(identifier = (IdentifierTree)annotationType).name().equals(this.name)) continue;
            this.context.reportIssue((JavaCheck)this, (Tree)identifier, String.format("Avoid using annotation @%s", this.name));
        }
        super.visitMethod(tree);
    }
}

