/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.collections;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.sonarsource.analyzer.commons.collections.AVLTree;

class TreeIterator<K, V>
implements Iterator<AVLTree<K, V>> {
    private final Deque<AVLTree<K, V>> stack = new ArrayDeque<AVLTree<K, V>>();
    private AVLTree<K, V> current;
    private AVLTree<K, V> inBucket;

    TreeIterator(AVLTree<K, V> root) {
        this.current = root;
        this.inBucket = null;
    }

    @Override
    public boolean hasNext() {
        return !this.stack.isEmpty() || !this.current.isEmpty() || this.inBucket != null;
    }

    @Override
    public AVLTree<K, V> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.inBucket != null) {
            AVLTree<K, V> previous = this.inBucket;
            this.inBucket = this.inBucket.nextInBucket();
            return previous;
        }
        while (!this.current.isEmpty()) {
            this.stack.push(this.current);
            this.current = this.current.left();
        }
        this.current = this.stack.pop();
        AVLTree<K, V> node = this.current;
        this.current = this.current.right();
        this.inBucket = node.nextInBucket();
        return node;
    }
}

