/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.samples.java.checks;

import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.samples.java.utils.PrinterVisitor;

@Rule(key="AvoidBrandInMethodNames")
public class AvoidBrandInMethodNamesRule
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(AvoidBrandInMethodNamesRule.class);
    private JavaFileScannerContext context;
    protected static final String COMPANY_NAME = "MyCompany";

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
        PrinterVisitor.print((Tree)context.getTree(), arg_0 -> ((Logger)LOGGER).debug(arg_0));
    }

    public void visitMethod(MethodTree tree) {
        if (tree.simpleName().name().toUpperCase(Locale.ROOT).contains(COMPANY_NAME.toUpperCase(Locale.ROOT))) {
            this.context.reportIssue((JavaCheck)this, (Tree)tree, "Avoid using Brand in method name");
        }
        super.visitMethod(tree);
    }
}

