/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.samples.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="AvoidSuperClass")
public class AvoidSuperClassRule
extends IssuableSubscriptionVisitor {
    public static final List<String> SUPER_CLASS_AVOID = Collections.singletonList("org.slf4j.Logger");

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree treeClazz = (ClassTree)tree;
        if (treeClazz.superClass() == null) {
            return;
        }
        String superClassName = treeClazz.superClass().symbolType().fullyQualifiedName();
        if (SUPER_CLASS_AVOID.contains(superClassName)) {
            this.reportIssue(tree, String.format("The usage of super class %s is forbidden", superClassName));
        }
    }
}

