/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.samples.java.checks;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.PackageDeclarationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;

@Rule(key="SecurityAnnotationMandatory")
public class SecurityAnnotationMandatoryRule
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityAnnotationMandatoryRule.class);
    private static final String DEFAULT_VALUE = "MySecurityAnnotation";
    private boolean implementsSpecificInterface = false;
    private JavaFileScannerContext context;
    @RuleProperty(defaultValue="MySecurityAnnotation", description="Name of the mandatory annotation")
    protected String name;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitClass(ClassTree tree) {
        this.implementsSpecificInterface = false;
        for (TypeTree typeTree : tree.superInterfaces()) {
            LOGGER.debug("implements Interface: {}", (Object)typeTree);
            if (!"MySecurityInterface".equals(typeTree.toString())) continue;
            this.implementsSpecificInterface = true;
        }
        super.visitClass(tree);
    }

    public void visitCompilationUnit(CompilationUnitTree tree) {
        PackageDeclarationTree packageDeclaration = tree.packageDeclaration();
        if (packageDeclaration != null) {
            SecurityAnnotationMandatoryRule.printPackageName(packageDeclaration.packageName());
        }
        super.visitCompilationUnit(tree);
    }

    private static void printPackageName(ExpressionTree packageName) {
        StringBuilder sb = new StringBuilder();
        ExpressionTree expr = packageName;
        while (expr.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            MemberSelectExpressionTree mse = (MemberSelectExpressionTree)expr;
            sb.insert(0, mse.identifier().name());
            sb.insert(0, mse.operatorToken().text());
            expr = mse.expression();
        }
        IdentifierTree idt = (IdentifierTree)expr;
        sb.insert(0, idt.name());
        LOGGER.debug("PackageName: {}", (Object)sb);
    }

    public void visitMethod(MethodTree tree) {
        if (this.implementsSpecificInterface) {
            List annotations = tree.modifiers().annotations();
            boolean isHavingMandatoryAnnotation = Boolean.FALSE;
            for (AnnotationTree annotationTree : annotations) {
                TypeTree annotationType = annotationTree.annotationType();
                if (!annotationType.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) continue;
                String annotationName = ((IdentifierTree)annotationType).name();
                LOGGER.debug("Method Name {}", (Object)annotationName);
                if (!annotationName.equals(this.name)) continue;
                isHavingMandatoryAnnotation = Boolean.TRUE;
            }
            if (!isHavingMandatoryAnnotation) {
                this.context.reportIssue((JavaCheck)this, (Tree)tree.simpleName(), String.format("Mandatory Annotation not set @%s", this.name));
            }
        }
        super.visitMethod(tree);
    }
}

