/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.samples.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="AvoidMethodWithSameTypeInArgument")
public class MyCustomSubscriptionRule
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        Type argType;
        MethodTree methodTree = (MethodTree)tree;
        Symbol.MethodSymbol methodSymbol = methodTree.symbol();
        Type returnType = methodSymbol.returnType().type();
        if (methodSymbol.parameterTypes().size() == 1 && (argType = (Type)methodSymbol.parameterTypes().get(0)).is(returnType.fullyQualifiedName())) {
            this.reportIssue(tree, "message");
        }
    }
}

