/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.samples.java;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="UnknownConstructorCall", priority=Priority.MINOR, name="Unknown constructor calls", description="Flag all unresolved class constructor calls")
public class UnknownConstructorCallCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitNewClass(NewClassTree tree) {
        if (tree.constructorSymbol().isUnknown()) {
            this.context.reportIssue((JavaCheck)this, (Tree)tree.identifier(), "Constructor not resolved");
        }
    }
}

