/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.samples.java;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="UnknownMethodInvocations", priority=Priority.MINOR, name="Unknown method invocations", description="Flag all unresolved method invocations")
public class UnknownMethodInvocationsCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitMethodInvocation(MethodInvocationTree tree) {
        if (tree.symbol().isUnknown()) {
            this.context.reportIssue((JavaCheck)this, (Tree)UnknownMethodInvocationsCheck.methodName(tree.methodSelect()), "Method not resolved");
        }
        super.visitMethodInvocation(tree);
    }

    private static IdentifierTree methodName(ExpressionTree methodSelect) {
        IdentifierTree id = methodSelect.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) ? (IdentifierTree)methodSelect : ((MemberSelectExpressionTree)methodSelect).identifier();
        return id;
    }
}

