/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.OrFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchExtension;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.config.Settings;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.WildcardPattern;

public abstract class AbstractJavaClasspath
implements BatchExtension {
    private static final char SEPARATOR = ',';
    private static final Logger LOG = LoggerFactory.getLogger(AbstractJavaClasspath.class);
    protected final Project project;
    protected final Settings settings;
    protected final FileSystem fs;
    private final InputFile.Type fileType;
    protected List<File> binaries;
    protected List<File> elements;
    protected boolean validateLibraries;
    protected boolean initialized;

    public AbstractJavaClasspath(Project project, Settings settings, FileSystem fs, InputFile.Type fileType) {
        this.project = project;
        this.settings = settings;
        this.fs = fs;
        this.fileType = fileType;
        this.initialized = false;
    }

    protected abstract void init();

    protected List<File> getFilesFromProperty(String property) {
        ArrayList result = Lists.newArrayList();
        String fileList = this.settings.getString(property);
        if (StringUtils.isNotEmpty((String)fileList)) {
            Iterable fileNames = Splitter.on((char)',').omitEmptyStrings().split((CharSequence)fileList);
            File baseDir = this.fs.baseDir();
            boolean hasJavaSources = this.hasJavaSources();
            boolean isLibraryProperty = property.endsWith("libraries");
            for (String pathPattern : fileNames) {
                List<File> libraryFilesForPattern = AbstractJavaClasspath.getFilesForPattern(baseDir, pathPattern, isLibraryProperty);
                if (this.validateLibraries && libraryFilesForPattern.isEmpty() && hasJavaSources) {
                    LOG.error("Invalid value for " + property);
                    String message = "No files nor directories matching '" + pathPattern + "'";
                    throw new IllegalStateException(message);
                }
                result.addAll(libraryFilesForPattern);
            }
        }
        return result;
    }

    private boolean hasJavaSources() {
        return this.fs.hasFiles(this.fs.predicates().and(this.fs.predicates().hasLanguage("java"), this.fs.predicates().hasType(this.fileType)));
    }

    private static List<File> getFilesForPattern(File baseDir, String pathPattern, boolean libraryProperty) {
        String filePattern;
        int lastPathSeparator;
        File file;
        String dirPath = pathPattern;
        if ((pathPattern.endsWith(".jar") || pathPattern.endsWith(".zip")) && (file = AbstractJavaClasspath.resolvePath(baseDir, pathPattern)).isFile()) {
            return Lists.newArrayList((Object[])new File[]{file});
        }
        int wildcardIndex = pathPattern.indexOf(42);
        if (wildcardIndex >= 0) {
            dirPath = pathPattern.substring(0, wildcardIndex);
        }
        if ((lastPathSeparator = Math.max(dirPath.lastIndexOf(47), dirPath.lastIndexOf(92))) == -1) {
            dirPath = ".";
            filePattern = pathPattern;
        } else {
            dirPath = pathPattern.substring(0, lastPathSeparator);
            filePattern = pathPattern.substring(lastPathSeparator + 1);
        }
        File dir = AbstractJavaClasspath.resolvePath(baseDir, dirPath);
        if (!dir.isDirectory()) {
            return Lists.newArrayList();
        }
        return AbstractJavaClasspath.getMatchingFiles(filePattern, dir, libraryProperty);
    }

    private static List<File> getMatchingFiles(String pattern, File dir, boolean libraryProperty) {
        WilcardPatternFileFilter wilcardPatternFileFilter;
        WilcardPatternFileFilter fileFilter = wilcardPatternFileFilter = new WilcardPatternFileFilter(dir, pattern);
        ArrayList files = Lists.newArrayList();
        if (libraryProperty) {
            if (pattern.endsWith("*")) {
                fileFilter = new AndFileFilter((IOFileFilter)fileFilter, (IOFileFilter)new OrFileFilter((List)Lists.newArrayList((Object[])new IOFileFilter[]{FileFilterUtils.suffixFileFilter((String)".jar", (IOCase)IOCase.INSENSITIVE), FileFilterUtils.suffixFileFilter((String)".zip", (IOCase)IOCase.INSENSITIVE)})));
            }
            files.addAll(Lists.newArrayList((Iterable)FileUtils.listFiles((File)dir, (IOFileFilter)fileFilter, (IOFileFilter)TrueFileFilter.TRUE)));
        }
        IOFileFilter subdirectories = pattern.isEmpty() ? FalseFileFilter.FALSE : TrueFileFilter.TRUE;
        Collection dirs = FileUtils.listFilesAndDirs((File)dir, (IOFileFilter)new AndFileFilter((IOFileFilter)wilcardPatternFileFilter, DirectoryFileFilter.DIRECTORY), (IOFileFilter)subdirectories);
        if (!pattern.isEmpty()) {
            dirs.remove(dir);
            Iterator iterator = dirs.iterator();
            while (iterator.hasNext()) {
                File matchingDir = (File)iterator.next();
                if (wilcardPatternFileFilter.accept(matchingDir)) continue;
                iterator.remove();
            }
        }
        if (libraryProperty) {
            for (File directory : dirs) {
                files.addAll(AbstractJavaClasspath.getMatchingFiles("**/*.jar", directory, true));
                files.addAll(AbstractJavaClasspath.getMatchingFiles("**/*.zip", directory, true));
            }
        }
        files.addAll(dirs);
        return files;
    }

    private static File resolvePath(File baseDir, String fileName) {
        File file = new File(fileName);
        if (!file.isAbsolute()) {
            file = new File(baseDir, fileName);
        }
        return file;
    }

    public List<File> getElements() {
        this.init();
        return this.elements;
    }

    public List<File> getBinaryDirs() {
        this.init();
        return this.binaries;
    }

    private static class WilcardPatternFileFilter
    implements IOFileFilter {
        private File baseDir;
        private WildcardPattern wildcardPattern;

        public WilcardPatternFileFilter(File baseDir, String wildcardPattern) {
            this.baseDir = baseDir;
            this.wildcardPattern = WildcardPattern.create((String)FilenameUtils.separatorsToSystem((String)wildcardPattern), (String)File.separator);
        }

        public boolean accept(File dir, String name) {
            return this.accept(new File(dir, name));
        }

        public boolean accept(File file) {
            String path = file.getAbsolutePath();
            path = path.substring(this.baseDir.getAbsolutePath().length() + 1);
            return this.wildcardPattern.match(path);
        }
    }
}

