/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitors;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Set;
import org.sonar.api.measures.FileLinesContext;
import org.sonar.java.SonarComponents;
import org.sonar.java.ast.visitors.SubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.SyntaxTrivia;
import org.sonar.plugins.java.api.tree.Tree;

public class FileLinesVisitor
extends SubscriptionVisitor {
    private final SonarComponents sonarComponents;
    private final Charset charset;
    private final Set<Integer> linesOfCode = Sets.newHashSet();
    private final Set<Integer> linesOfComments = Sets.newHashSet();

    public FileLinesVisitor(SonarComponents sonarComponents, Charset charset) {
        this.sonarComponents = sonarComponents;
        this.charset = charset;
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)((Object)Tree.Kind.TOKEN));
    }

    @Override
    public void scanFile(JavaFileScannerContext context) {
        int fileLength;
        super.scanFile(context);
        FileLinesContext fileLinesContext = this.sonarComponents.fileLinesContextFor(context.getFile());
        try {
            fileLength = Files.readLines((File)context.getFile(), (Charset)this.charset).size();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        for (int line = 1; line <= fileLength; ++line) {
            fileLinesContext.setIntValue("ncloc_data", line, this.linesOfCode.contains(line) ? 1 : 0);
            fileLinesContext.setIntValue("comment_lines_data", line, this.linesOfComments.contains(line) ? 1 : 0);
        }
        fileLinesContext.save();
        this.linesOfCode.clear();
        this.linesOfComments.clear();
    }

    @Override
    public void visitToken(SyntaxToken syntaxToken) {
        this.linesOfCode.add(syntaxToken.line());
        for (SyntaxTrivia trivia : syntaxToken.trivias()) {
            int baseLine = trivia.startLine();
            String[] lines = trivia.comment().split("(\r)?\n|\r", -1);
            for (int i = 0; i < lines.length; ++i) {
                this.linesOfComments.add(baseLine + i);
            }
        }
    }
}

