/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitors;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sonar.api.source.Highlightable;
import org.sonar.java.SonarComponents;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.visitors.SubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.SyntaxTrivia;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;

public class SyntaxHighlighterVisitor
extends SubscriptionVisitor {
    private final SonarComponents sonarComponents;
    private final Map<Tree.Kind, String> typesByKind;
    private final Set<String> keywords;
    private final Charset charset;
    private Highlightable.HighlightingBuilder highlighting;
    private List<Integer> lineStart;

    public SyntaxHighlighterVisitor(SonarComponents sonarComponents, Charset charset) {
        this.sonarComponents = sonarComponents;
        this.charset = charset;
        ImmutableSet.Builder keywordsBuilder = ImmutableSet.builder();
        keywordsBuilder.add((Object[])JavaKeyword.keywordValues());
        this.keywords = keywordsBuilder.build();
        ImmutableMap.Builder typesByKindBuilder = ImmutableMap.builder();
        typesByKindBuilder.put((Object)Tree.Kind.STRING_LITERAL, (Object)"s");
        typesByKindBuilder.put((Object)Tree.Kind.CHAR_LITERAL, (Object)"s");
        typesByKindBuilder.put((Object)Tree.Kind.FLOAT_LITERAL, (Object)"c");
        typesByKindBuilder.put((Object)Tree.Kind.DOUBLE_LITERAL, (Object)"c");
        typesByKindBuilder.put((Object)Tree.Kind.LONG_LITERAL, (Object)"c");
        typesByKindBuilder.put((Object)Tree.Kind.INT_LITERAL, (Object)"c");
        typesByKindBuilder.put((Object)Tree.Kind.ANNOTATION, (Object)"a");
        this.typesByKind = typesByKindBuilder.build();
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.builder().addAll(this.typesByKind.keySet().iterator()).add((Object)Tree.Kind.TOKEN).add((Object)Tree.Kind.TRIVIA).build();
    }

    @Override
    public void scanFile(JavaFileScannerContext context) {
        File file = context.getFile();
        this.highlighting = this.sonarComponents.highlightableFor(file).newHighlighting();
        this.lineStart = SyntaxHighlighterVisitor.startLines(file, this.charset);
        super.scanFile(context);
        this.highlighting.done();
        this.lineStart.clear();
    }

    @Override
    public void visitNode(Tree tree) {
        if (tree.is(Tree.Kind.ANNOTATION)) {
            AnnotationTree annotationTree = (AnnotationTree)tree;
            this.highlighting.highlight(this.start(annotationTree), this.end(annotationTree), this.typesByKind.get((Object)Tree.Kind.ANNOTATION));
        } else {
            Tree.Kind kind = tree.kind();
            if (this.typesByKind.containsKey((Object)kind)) {
                SyntaxToken token = ((LiteralTree)tree).token();
                this.highlighting.highlight(this.start(token), this.end(token), this.typesByKind.get((Object)kind));
            }
        }
    }

    @Override
    public void visitToken(SyntaxToken syntaxToken) {
        String text = syntaxToken.text();
        if (this.keywords.contains(text)) {
            this.highlighting.highlight(this.start(syntaxToken), this.end(syntaxToken), "k");
        }
    }

    @Override
    public void visitTrivia(SyntaxTrivia syntaxTrivia) {
        this.highlighting.highlight(this.start(syntaxTrivia), this.end(syntaxTrivia), "cppd");
    }

    private int start(AnnotationTree annotationTree) {
        return this.start(annotationTree.atToken());
    }

    private int start(SyntaxToken token) {
        return this.getOffset(token.line(), token.column());
    }

    private int start(SyntaxTrivia syntaxTrivia) {
        return this.getOffset(syntaxTrivia.startLine(), syntaxTrivia.column());
    }

    private int getOffset(int line, int column) {
        return this.lineStart.get(line - 1) + column;
    }

    private int end(AnnotationTree annotationTree) {
        TypeTree annotationType = annotationTree.annotationType();
        SyntaxToken token = annotationType.is(Tree.Kind.MEMBER_SELECT) ? ((MemberSelectExpressionTree)annotationType).identifier().identifierToken() : ((IdentifierTree)annotationType).identifierToken();
        return this.end(token);
    }

    private int end(SyntaxToken token) {
        return this.getOffset(token.line(), token.column()) + token.text().length();
    }

    private int end(SyntaxTrivia trivia) {
        return this.getOffset(trivia.startLine(), trivia.column()) + trivia.comment().length();
    }

    private static List<Integer> startLines(File file, Charset charset) {
        String content;
        ArrayList startLines = Lists.newArrayList();
        try {
            content = Files.toString((File)file, (Charset)charset);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        startLines.add(0);
        int contentLength = content.length();
        for (int i = 0; i < contentLength; ++i) {
            char currentChar = content.charAt(i);
            if (currentChar != '\n' && (currentChar != '\r' || i + 1 >= contentLength || content.charAt(i + 1) == '\n')) continue;
            startLines.add(i + 1);
        }
        return startLines;
    }
}

