/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.filters;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Map;
import org.sonar.api.issue.Issue;
import org.sonar.api.issue.batch.IssueFilter;
import org.sonar.api.issue.batch.IssueFilterChain;
import org.sonar.api.rule.RuleKey;

public class SuppressWarningsFilter
implements IssueFilter {
    private final Map<String, Multimap<Integer, String>> suppressWarningsLinesByResource = Maps.newHashMap();

    public void addComponent(String componentKey, Multimap<Integer, String> warningLines) {
        this.suppressWarningsLinesByResource.put(componentKey, warningLines);
    }

    public boolean accept(Issue issue, IssueFilterChain chain) {
        for (String warning : this.getWarningsByLine(issue)) {
            if (!SuppressWarningsFilter.issueShouldNotBeReported(warning, issue)) continue;
            return false;
        }
        return chain.accept(issue);
    }

    private Collection<String> getWarningsByLine(Issue issue) {
        Integer line = issue.line();
        String componentKey = issue.componentKey();
        if (line != null && this.suppressWarningsLinesByResource.containsKey(componentKey)) {
            return this.suppressWarningsLinesByResource.get(componentKey).get((Object)line);
        }
        return Sets.newTreeSet();
    }

    private static boolean issueShouldNotBeReported(String warning, Issue issue) {
        RuleKey ruleKey = issue.ruleKey();
        return (SuppressWarningsFilter.warningIsRuleKey(warning, ruleKey) || "all".equals(warning)) && !SuppressWarningsFilter.isSuppressWarningRule(ruleKey);
    }

    private static boolean warningIsRuleKey(String warning, RuleKey ruleKey) {
        try {
            return ruleKey.equals((Object)RuleKey.parse((String)warning));
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private static boolean isSuppressWarningRule(RuleKey ruleKey) {
        return "S1309".equals(ruleKey.rule());
    }
}

