/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.sonar.java.AnalyzerMessage;
import org.sonar.java.SonarComponents;
import org.sonar.java.ast.visitors.ComplexityVisitor;
import org.sonar.java.model.JavaTree;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.java.se.checks.SECheck;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

public class DefaultJavaFileScannerContext
implements JavaFileScannerContext {
    private final CompilationUnitTree tree;
    @VisibleForTesting
    private final SemanticModel semanticModel;
    private final SonarComponents sonarComponents;
    private final ComplexityVisitor complexityVisitor;
    private final File file;
    private final JavaVersion javaVersion;
    private final boolean fileParsed;
    private final Map<Class<? extends SECheck>, SetMultimap<Tree, SEIssue>> seIssues = new HashMap<Class<? extends SECheck>, SetMultimap<Tree, SEIssue>>();

    public DefaultJavaFileScannerContext(CompilationUnitTree tree, File file, SemanticModel semanticModel, boolean analyseAccessors, @Nullable SonarComponents sonarComponents, JavaVersion javaVersion, boolean fileParsed) {
        this.tree = tree;
        this.file = file;
        this.semanticModel = semanticModel;
        this.sonarComponents = sonarComponents;
        this.complexityVisitor = new ComplexityVisitor(analyseAccessors);
        this.javaVersion = javaVersion;
        this.fileParsed = fileParsed;
    }

    @Override
    public CompilationUnitTree getTree() {
        return this.tree;
    }

    @Override
    public void addIssue(Tree tree, JavaCheck javaCheck, String message) {
        this.addIssue(((JavaTree)tree).getLine(), javaCheck, message, null);
    }

    @Override
    public void addIssue(Tree tree, JavaCheck check, String message, @Nullable Double cost) {
        this.addIssue(((JavaTree)tree).getLine(), check, message, cost);
    }

    @Override
    public void addIssueOnFile(JavaCheck javaCheck, String message) {
        this.addIssue(-1, javaCheck, message);
    }

    @Override
    public void addIssue(int line, JavaCheck javaCheck, String message) {
        this.addIssue(line, javaCheck, message, null);
    }

    @Override
    public void addIssue(int line, JavaCheck javaCheck, String message, @Nullable Double cost) {
        this.sonarComponents.addIssue(this.file, javaCheck, line, message, cost);
    }

    @Override
    @Nullable
    public Object getSemanticModel() {
        return this.semanticModel;
    }

    @Override
    public JavaVersion getJavaVersion() {
        return this.javaVersion;
    }

    @Override
    public boolean fileParsed() {
        return this.fileParsed;
    }

    @Override
    public String getFileKey() {
        return this.file.getAbsolutePath();
    }

    @Override
    public void addIssue(File file, JavaCheck check, int line, String message) {
        if (this.sonarComponents != null) {
            this.sonarComponents.addIssue(file, check, line, message, null);
        }
    }

    @Override
    public void reportIssue(JavaCheck javaCheck, Tree tree, String message) {
        this.reportIssue(javaCheck, tree, message, (List<JavaFileScannerContext.Location>)ImmutableList.of(), null);
    }

    @Override
    public void reportIssue(JavaCheck javaCheck, Tree syntaxNode, String message, List<JavaFileScannerContext.Location> secondary, @Nullable Integer cost) {
        this.sonarComponents.reportIssue(this.createAnalyzerMessage(javaCheck, syntaxNode, message, secondary, cost));
    }

    private AnalyzerMessage createAnalyzerMessage(JavaCheck javaCheck, Tree syntaxNode, String message, List<JavaFileScannerContext.Location> secondary, @Nullable Integer cost) {
        AnalyzerMessage analyzerMessage = new AnalyzerMessage(javaCheck, this.file, AnalyzerMessage.textSpanFor(syntaxNode), message, cost != null ? cost : 0);
        for (JavaFileScannerContext.Location location : secondary) {
            AnalyzerMessage secondaryLocation = new AnalyzerMessage(javaCheck, this.file, AnalyzerMessage.textSpanFor(location.syntaxNode), location.msg, 0);
            analyzerMessage.secondaryLocations.add(secondaryLocation);
        }
        return analyzerMessage;
    }

    @Override
    public void reportIssue(JavaCheck javaCheck, Tree startTree, Tree endTree, String message) {
        this.sonarComponents.reportIssue(new AnalyzerMessage(javaCheck, this.file, AnalyzerMessage.textSpanBetween(startTree, endTree), message, 0));
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public List<Tree> getComplexityNodes(Tree tree) {
        return this.complexityVisitor.scan(tree);
    }

    @Override
    public List<Tree> getMethodComplexityNodes(ClassTree enclosingClass, MethodTree methodTree) {
        return this.complexityVisitor.scan(enclosingClass, methodTree);
    }

    public void reportSEIssue(Class<? extends SECheck> check, Tree tree, String message, List<JavaFileScannerContext.Location> secondary) {
        if (!this.seIssues.containsKey(check)) {
            this.seIssues.put(check, (SetMultimap<Tree, SEIssue>)LinkedHashMultimap.create());
        }
        this.seIssues.get(check).put((Object)tree, (Object)new SEIssue(tree, message, secondary));
    }

    public Multimap<Tree, SEIssue> getSEIssues(Class<? extends SECheck> check) {
        if (this.seIssues.containsKey(check)) {
            return (Multimap)this.seIssues.get(check);
        }
        return ImmutableMultimap.of();
    }

    public static class SEIssue {
        private final Tree tree;
        private final String message;
        private final List<JavaFileScannerContext.Location> secondary;

        public SEIssue(Tree tree, String message, List<JavaFileScannerContext.Location> secondary) {
            this.tree = tree;
            this.message = message;
            this.secondary = secondary;
        }

        public Tree getTree() {
            return this.tree;
        }

        public String getMessage() {
            return this.message;
        }

        public List<JavaFileScannerContext.Location> getSecondary() {
            return this.secondary;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SEIssue seIssue = (SEIssue)o;
            return Objects.equals(this.tree, seIssue.tree) && Objects.equals(this.message, seIssue.message) && Objects.equals(this.secondary, seIssue.secondary);
        }

        public int hashCode() {
            return Objects.hash(this.tree, this.message, this.secondary);
        }
    }
}

