/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.plugins.java.api.JavaVersion;

public class JavaVersionImpl
implements JavaVersion {
    private static final Logger LOG = LoggerFactory.getLogger(JavaVersionImpl.class);
    private static final int JAVA_7 = 7;
    private static final int JAVA_8 = 8;
    private final int javaVersion;

    public JavaVersionImpl() {
        this.javaVersion = -1;
    }

    public JavaVersionImpl(int javaVersion) {
        this.javaVersion = javaVersion;
    }

    public static JavaVersion fromString(String javaVersion) {
        if (javaVersion != null) {
            try {
                return new JavaVersionImpl(Integer.parseInt(javaVersion.replaceAll("1.", "")));
            }
            catch (NumberFormatException e) {
                LOG.warn("Invalid java version (got \"" + javaVersion + "\"). " + "The version will be ignored. Accepted formats are \"1.X\", or simply \"X\" " + "(for instance: \"1.5\" or \"5\", \"1.6\" or \"6\", \"1.7\" or \"7\", etc.)");
            }
        }
        return new JavaVersionImpl();
    }

    @Override
    public boolean isJava7Compatible() {
        return this.notSetOrAtLeast(7);
    }

    @Override
    public boolean isJava8Compatible() {
        return this.notSetOrAtLeast(8);
    }

    private boolean notSetOrAtLeast(int requiredJavaVersion) {
        return this.isNotSet() || requiredJavaVersion <= this.javaVersion;
    }

    @Override
    public String java7CompatibilityMessage() {
        return this.compatibilityMessage(7);
    }

    @Override
    public String java8CompatibilityMessage() {
        return this.compatibilityMessage(8);
    }

    private String compatibilityMessage(int expected) {
        return this.isNotSet() ? " (sonar.java.source not set. Assuming " + expected + " or greater.)" : "";
    }

    @Override
    public int asInt() {
        return this.javaVersion;
    }

    @Override
    public boolean isNotSet() {
        return this.javaVersion == -1;
    }

    public String toString() {
        return this.isNotSet() ? "none" : Integer.toString(this.javaVersion);
    }
}

