/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.sonar.sslr.api.RecognitionException;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.java.CharsetAwareVisitor;
import org.sonar.java.JavaVersionAwareVisitor;
import org.sonar.java.SonarComponents;
import org.sonar.java.ast.visitors.SonarSymbolTableVisitor;
import org.sonar.java.model.DefaultJavaFileScannerContext;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.PackageUtils;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.java.se.SymbolicExecutionVisitor;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.AstScannerExceptionHandler;

public class VisitorsBridge {
    private static final Logger LOG = LoggerFactory.getLogger(VisitorsBridge.class);
    private final List<JavaFileScanner> scanners;
    private List<JavaFileScanner> executableScanners;
    private final SonarComponents sonarComponents;
    private final boolean symbolicExecutionEnabled;
    private SemanticModel semanticModel;
    private List<File> projectClasspath;
    private boolean analyseAccessors;
    protected File currentFile;
    protected JavaVersion javaVersion;

    @VisibleForTesting
    public VisitorsBridge(JavaFileScanner visitor) {
        this(Collections.singletonList(visitor), Lists.newArrayList(), null);
    }

    @VisibleForTesting
    public VisitorsBridge(Iterable visitors, List<File> projectClasspath, @Nullable SonarComponents sonarComponents) {
        this(visitors, projectClasspath, sonarComponents, true);
    }

    public VisitorsBridge(Iterable visitors, List<File> projectClasspath, @Nullable SonarComponents sonarComponents, boolean symbolicExecutionEnabled) {
        ImmutableList.Builder scannersBuilder = ImmutableList.builder();
        for (Object visitor : visitors) {
            if (!(visitor instanceof JavaFileScanner)) continue;
            scannersBuilder.add((Object)((JavaFileScanner)visitor));
        }
        this.scanners = scannersBuilder.build();
        this.executableScanners = this.scanners;
        this.sonarComponents = sonarComponents;
        this.projectClasspath = projectClasspath;
        this.symbolicExecutionEnabled = symbolicExecutionEnabled;
    }

    public void setAnalyseAccessors(boolean analyseAccessors) {
        this.analyseAccessors = analyseAccessors;
    }

    public void setCharset(Charset charset) {
        for (JavaFileScanner scanner : this.scanners) {
            if (!(scanner instanceof CharsetAwareVisitor)) continue;
            ((CharsetAwareVisitor)((Object)scanner)).setCharset(charset);
        }
    }

    public void setJavaVersion(JavaVersion javaVersion) {
        this.javaVersion = javaVersion;
        this.executableScanners = VisitorsBridge.executableScanners(this.scanners, javaVersion);
    }

    public void visitFile(@Nullable Tree parsedTree) {
        boolean fileParsed;
        this.semanticModel = null;
        CompilationUnitTree tree = new JavaTree.CompilationUnitTreeImpl(null, Lists.newArrayList(), Lists.newArrayList(), null);
        boolean bl = fileParsed = parsedTree != null;
        if (fileParsed && parsedTree.is(Tree.Kind.COMPILATION_UNIT)) {
            tree = (CompilationUnitTree)parsedTree;
            if (this.isNotJavaLangOrSerializable(PackageUtils.packageName(tree.packageDeclaration(), "/"))) {
                try {
                    this.semanticModel = SemanticModel.createFor(tree, this.getProjectClasspath());
                }
                catch (Exception e) {
                    LOG.error("Unable to create symbol table for : " + this.currentFile.getAbsolutePath(), (Throwable)e);
                    return;
                }
                this.createSonarSymbolTable(tree);
            } else {
                SemanticModel.handleMissingTypes(tree);
            }
        }
        JavaFileScannerContext javaFileScannerContext = this.createScannerContext(tree, this.semanticModel, this.analyseAccessors, this.sonarComponents, fileParsed);
        if (this.symbolicExecutionEnabled && this.isNotJavaLangOrSerializable(PackageUtils.packageName(tree.packageDeclaration(), "/"))) {
            new SymbolicExecutionVisitor(this.executableScanners).scanFile(javaFileScannerContext);
        }
        for (JavaFileScanner scanner : this.executableScanners) {
            scanner.scanFile(javaFileScannerContext);
        }
        if (this.semanticModel != null) {
            this.semanticModel.done();
        }
    }

    private static List<JavaFileScanner> executableScanners(List<JavaFileScanner> scanners, JavaVersion javaVersion) {
        ImmutableList.Builder results = ImmutableList.builder();
        for (JavaFileScanner scanner : scanners) {
            if (scanner instanceof JavaVersionAwareVisitor && !((JavaVersionAwareVisitor)((Object)scanner)).isCompatibleWithJavaVersion(javaVersion)) continue;
            results.add((Object)scanner);
        }
        return results.build();
    }

    protected JavaFileScannerContext createScannerContext(CompilationUnitTree tree, SemanticModel semanticModel, boolean analyseAccessors, SonarComponents sonarComponents, boolean fileParsed) {
        return new DefaultJavaFileScannerContext(tree, this.currentFile, semanticModel, analyseAccessors, sonarComponents, this.javaVersion, fileParsed);
    }

    private boolean isNotJavaLangOrSerializable(String packageName) {
        String name = this.currentFile.getName();
        return !VisitorsBridge.inJavaLang(packageName) && !VisitorsBridge.isAnnotation(packageName, name) && !VisitorsBridge.isSerializable(packageName, name);
    }

    private static boolean isSerializable(String packageName, String name) {
        return "java/io".equals(packageName) && "Serializable.java".equals(name);
    }

    private static boolean isAnnotation(String packageName, String name) {
        return "java/lang/annotation".equals(packageName) && "Annotation.java".equals(name);
    }

    private static boolean inJavaLang(String packageName) {
        return "java/lang".equals(packageName);
    }

    private List<File> getProjectClasspath() {
        return this.projectClasspath;
    }

    private void createSonarSymbolTable(CompilationUnitTree tree) {
        if (this.sonarComponents != null) {
            SonarSymbolTableVisitor symVisitor = new SonarSymbolTableVisitor(this.sonarComponents.symbolizableFor(this.currentFile), this.semanticModel);
            symVisitor.visitCompilationUnit(tree);
        }
    }

    public void processRecognitionException(RecognitionException e) {
        for (JavaFileScanner scanner : this.scanners) {
            if (!(scanner instanceof AstScannerExceptionHandler)) continue;
            ((AstScannerExceptionHandler)scanner).processRecognitionException(e);
        }
    }

    public void setCurrentFile(File currentFile) {
        this.currentFile = currentFile;
    }
}

